/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InvoicingLocation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="address1")
    private final String address1;
    @JsonProperty(value="address2")
    private final String address2;
    @JsonProperty(value="postalCode")
    private final String postalCode;
    @JsonProperty(value="city")
    private final String city;
    @JsonProperty(value="country")
    private final String country;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="tcaLocationId")
    private final Long tcaLocationId;

    @Deprecated
    @ConstructorProperties(value={"address1", "address2", "postalCode", "city", "country", "region", "tcaLocationId"})
    public InvoicingLocation(String address1, String address2, String postalCode, String city, String country, String region, Long tcaLocationId) {
        this.address1 = address1;
        this.address2 = address2;
        this.postalCode = postalCode;
        this.city = city;
        this.country = country;
        this.region = region;
        this.tcaLocationId = tcaLocationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getRegion() {
        return this.region;
    }

    public Long getTcaLocationId() {
        return this.tcaLocationId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InvoicingLocation(");
        sb.append("super=").append(super.toString());
        sb.append("address1=").append(String.valueOf(this.address1));
        sb.append(", address2=").append(String.valueOf(this.address2));
        sb.append(", postalCode=").append(String.valueOf(this.postalCode));
        sb.append(", city=").append(String.valueOf(this.city));
        sb.append(", country=").append(String.valueOf(this.country));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", tcaLocationId=").append(String.valueOf(this.tcaLocationId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvoicingLocation)) {
            return false;
        }
        InvoicingLocation other = (InvoicingLocation)((Object)o);
        return Objects.equals(this.address1, other.address1) && Objects.equals(this.address2, other.address2) && Objects.equals(this.postalCode, other.postalCode) && Objects.equals(this.city, other.city) && Objects.equals(this.country, other.country) && Objects.equals(this.region, other.region) && Objects.equals(this.tcaLocationId, other.tcaLocationId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.address1 == null ? 43 : this.address1.hashCode());
        result = result * 59 + (this.address2 == null ? 43 : this.address2.hashCode());
        result = result * 59 + (this.postalCode == null ? 43 : this.postalCode.hashCode());
        result = result * 59 + (this.city == null ? 43 : this.city.hashCode());
        result = result * 59 + (this.country == null ? 43 : this.country.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.tcaLocationId == null ? 43 : this.tcaLocationId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="address1")
        private String address1;
        @JsonProperty(value="address2")
        private String address2;
        @JsonProperty(value="postalCode")
        private String postalCode;
        @JsonProperty(value="city")
        private String city;
        @JsonProperty(value="country")
        private String country;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="tcaLocationId")
        private Long tcaLocationId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder address1(String address1) {
            this.address1 = address1;
            this.__explicitlySet__.add("address1");
            return this;
        }

        public Builder address2(String address2) {
            this.address2 = address2;
            this.__explicitlySet__.add("address2");
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            this.__explicitlySet__.add("postalCode");
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            this.__explicitlySet__.add("city");
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            this.__explicitlySet__.add("country");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder tcaLocationId(Long tcaLocationId) {
            this.tcaLocationId = tcaLocationId;
            this.__explicitlySet__.add("tcaLocationId");
            return this;
        }

        public InvoicingLocation build() {
            InvoicingLocation model = new InvoicingLocation(this.address1, this.address2, this.postalCode, this.city, this.country, this.region, this.tcaLocationId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InvoicingLocation model) {
            if (model.wasPropertyExplicitlySet("address1")) {
                this.address1(model.getAddress1());
            }
            if (model.wasPropertyExplicitlySet("address2")) {
                this.address2(model.getAddress2());
            }
            if (model.wasPropertyExplicitlySet("postalCode")) {
                this.postalCode(model.getPostalCode());
            }
            if (model.wasPropertyExplicitlySet("city")) {
                this.city(model.getCity());
            }
            if (model.wasPropertyExplicitlySet("country")) {
                this.country(model.getCountry());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("tcaLocationId")) {
                this.tcaLocationId(model.getTcaLocationId());
            }
            return this;
        }
    }
}

