/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.onesubscription.Ratecard;
import com.oracle.bmc.onesubscription.RatecardPaginators;
import com.oracle.bmc.onesubscription.model.RateCardSummary;
import com.oracle.bmc.onesubscription.requests.ListRateCardsRequest;
import com.oracle.bmc.onesubscription.responses.ListRateCardsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatecardClient
extends BaseSyncClient
implements Ratecard {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RATECARD").serviceEndpointPrefix("").serviceEndpointTemplate("https://identity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RatecardClient.class);
    private final RatecardPaginators paginators = new RatecardPaginators(this);

    RatecardClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ListRateCardsResponse listRateCards(ListRateCardsRequest request) {
        Objects.requireNonNull(request.getSubscriptionId(), "subscriptionId is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRateCardsResponse)this.clientCall(request, ListRateCardsResponse::builder).logger(LOG, "listRateCards").serviceDetails("Ratecard", "ListRateCards", "").method(Method.GET).requestBuilder(ListRateCardsRequest::builder).basePath("/20190111").appendPathParam("ratecards").appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("timeFrom", (Object)request.getTimeFrom()).appendQueryParam("timeTo", (Object)request.getTimeTo()).appendQueryParam("partNumber", (Object)request.getPartNumber()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(RateCardSummary.class, ListRateCardsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListRateCardsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRateCardsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RatecardPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public RatecardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RatecardClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RatecardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RatecardClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RatecardClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RatecardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RatecardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RatecardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public RatecardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RatecardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public RatecardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RatecardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public RatecardClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RatecardClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RatecardClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "onesubscription";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"onesubscription");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RatecardClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RatecardClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

