/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCommitmentRequest
extends BmcRequest<Void> {
    private String commitmentId;
    private String opcRequestId;

    public String getCommitmentId() {
        return this.commitmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().commitmentId(this.commitmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",commitmentId=").append(String.valueOf(this.commitmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCommitmentRequest)) {
            return false;
        }
        GetCommitmentRequest other = (GetCommitmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.commitmentId, other.commitmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.commitmentId == null ? 43 : this.commitmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCommitmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String commitmentId = null;
        private String opcRequestId = null;

        public Builder commitmentId(String commitmentId) {
            this.commitmentId = commitmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCommitmentRequest o) {
            this.commitmentId(o.getCommitmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCommitmentRequest build() {
            GetCommitmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCommitmentRequest buildWithoutInvocationCallback() {
            GetCommitmentRequest request = new GetCommitmentRequest();
            request.commitmentId = this.commitmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

