/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.ons.model.ConfirmationResult;
import com.oracle.bmc.ons.requests.GetConfirmSubscriptionRequest;
import com.oracle.bmc.ons.responses.GetConfirmSubscriptionResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetConfirmSubscriptionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetConfirmSubscriptionConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetConfirmSubscriptionRequest interceptRequest(GetConfirmSubscriptionRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetConfirmSubscriptionRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getToken(), (String)"token is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getProtocol(), (String)"protocol is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181201").path("subscriptions").path(HttpUtils.encodePathSegment((String)request.getId())).path("confirmation");
        target = target.queryParam("token", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getToken())});
        target = target.queryParam("protocol", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getProtocol())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetConfirmSubscriptionResponse> fromResponse() {
        Function<Response, GetConfirmSubscriptionResponse> transformer = new Function<Response, GetConfirmSubscriptionResponse>(){

            public GetConfirmSubscriptionResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.ons.responses.GetConfirmSubscriptionResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ConfirmationResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetConfirmSubscriptionResponse.Builder builder = GetConfirmSubscriptionResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.confirmationResult((ConfirmationResult)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                GetConfirmSubscriptionResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

