/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTopicRequest
extends BmcRequest<Void> {
    private String topicId;
    private String opcRequestId;

    @ConstructorProperties(value={"topicId", "opcRequestId"})
    GetTopicRequest(String topicId, String opcRequestId) {
        this.topicId = topicId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTopicId() {
        return this.topicId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTopicRequest, Void> {
        private String topicId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTopicRequest o) {
            this.topicId(o.getTopicId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTopicRequest build() {
            GetTopicRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetTopicRequest buildWithoutInvocationCallback() {
            return new GetTopicRequest(this.topicId, this.opcRequestId);
        }

        public String toString() {
            return "GetTopicRequest.Builder(topicId=" + this.topicId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

