/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.ons.model.MessageDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class PublishMessageRequest
extends BmcRequest<MessageDetails> {
    private String topicId;
    private MessageDetails messageDetails;
    private String opcRequestId;
    private MessageType messageType;

    @InternalSdk
    public MessageDetails getBody$() {
        return this.messageDetails;
    }

    @ConstructorProperties(value={"topicId", "messageDetails", "opcRequestId", "messageType"})
    PublishMessageRequest(String topicId, MessageDetails messageDetails, String opcRequestId, MessageType messageType) {
        this.topicId = topicId;
        this.messageDetails = messageDetails;
        this.opcRequestId = opcRequestId;
        this.messageType = messageType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTopicId() {
        return this.topicId;
    }

    public MessageDetails getMessageDetails() {
        return this.messageDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public static class Builder
    implements BmcRequest.Builder<PublishMessageRequest, MessageDetails> {
        private String topicId;
        private MessageDetails messageDetails;
        private String opcRequestId;
        private MessageType messageType;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PublishMessageRequest o) {
            this.topicId(o.getTopicId());
            this.messageDetails(o.getMessageDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.messageType(o.getMessageType());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PublishMessageRequest build() {
            PublishMessageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(MessageDetails body) {
            this.messageDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public Builder messageDetails(MessageDetails messageDetails) {
            this.messageDetails = messageDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public PublishMessageRequest buildWithoutInvocationCallback() {
            return new PublishMessageRequest(this.topicId, this.messageDetails, this.opcRequestId, this.messageType);
        }

        public String toString() {
            return "PublishMessageRequest.Builder(topicId=" + this.topicId + ", messageDetails=" + this.messageDetails + ", opcRequestId=" + this.opcRequestId + ", messageType=" + (Object)((Object)this.messageType) + ")";
        }
    }

    public static enum MessageType {
        Json("JSON"),
        RawText("RAW_TEXT");

        private final String value;
        private static Map<String, MessageType> map;

        private MessageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid MessageType: " + key);
        }

        static {
            map = new HashMap<String, MessageType>();
            for (MessageType v : MessageType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

