/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.oracle.bmc.ons.NotificationDataPlane;
import com.oracle.bmc.ons.model.SubscriptionSummary;
import com.oracle.bmc.ons.requests.ListSubscriptionsRequest;
import com.oracle.bmc.ons.responses.ListSubscriptionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class NotificationDataPlanePaginators {
    private final NotificationDataPlane client;

    public NotificationDataPlanePaginators(NotificationDataPlane client) {
        this.client = client;
    }

    public Iterable<ListSubscriptionsResponse> listSubscriptionsResponseIterator(final ListSubscriptionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSubscriptionsRequest.Builder>(){

            @Override
            public ListSubscriptionsRequest.Builder get() {
                return ListSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionsResponse, String>(){

            @Override
            public String apply(ListSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionsRequest.Builder>, ListSubscriptionsRequest>(){

            @Override
            public ListSubscriptionsRequest apply(RequestBuilderAndToken<ListSubscriptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscriptionsRequest, ListSubscriptionsResponse>(){

            @Override
            public ListSubscriptionsResponse apply(ListSubscriptionsRequest request) {
                return NotificationDataPlanePaginators.this.client.listSubscriptions(request);
            }
        });
    }

    public Iterable<SubscriptionSummary> listSubscriptionsRecordIterator(final ListSubscriptionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSubscriptionsRequest.Builder>(){

            @Override
            public ListSubscriptionsRequest.Builder get() {
                return ListSubscriptionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscriptionsResponse, String>(){

            @Override
            public String apply(ListSubscriptionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscriptionsRequest.Builder>, ListSubscriptionsRequest>(){

            @Override
            public ListSubscriptionsRequest apply(RequestBuilderAndToken<ListSubscriptionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscriptionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscriptionsRequest, ListSubscriptionsResponse>(){

            @Override
            public ListSubscriptionsResponse apply(ListSubscriptionsRequest request) {
                return NotificationDataPlanePaginators.this.client.listSubscriptions(request);
            }
        }, (Function)new Function<ListSubscriptionsResponse, List<SubscriptionSummary>>(){

            @Override
            public List<SubscriptionSummary> apply(ListSubscriptionsResponse response) {
                return response.getItems();
            }
        });
    }
}

