/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConfirmSubscriptionRequest
extends BmcRequest<Void> {
    private String id;
    private String token;
    private String protocol;
    private String opcRequestId;

    public String getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).token(this.token).protocol(this.protocol).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",token=").append(String.valueOf(this.token));
        sb.append(",protocol=").append(String.valueOf(this.protocol));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConfirmSubscriptionRequest)) {
            return false;
        }
        GetConfirmSubscriptionRequest other = (GetConfirmSubscriptionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals(this.token, other.token) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.token == null ? 43 : this.token.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConfirmSubscriptionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private String token = null;
        private String protocol = null;
        private String opcRequestId = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConfirmSubscriptionRequest o) {
            this.id(o.getId());
            this.token(o.getToken());
            this.protocol(o.getProtocol());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConfirmSubscriptionRequest build() {
            GetConfirmSubscriptionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConfirmSubscriptionRequest buildWithoutInvocationCallback() {
            GetConfirmSubscriptionRequest request = new GetConfirmSubscriptionRequest();
            request.id = this.id;
            request.token = this.token;
            request.protocol = this.protocol;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

