/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.ons.NotificationControlPlaneAsync;
import com.oracle.bmc.ons.model.NotificationTopic;
import com.oracle.bmc.ons.model.NotificationTopicSummary;
import com.oracle.bmc.ons.requests.ChangeTopicCompartmentRequest;
import com.oracle.bmc.ons.requests.CreateTopicRequest;
import com.oracle.bmc.ons.requests.DeleteTopicRequest;
import com.oracle.bmc.ons.requests.GetTopicRequest;
import com.oracle.bmc.ons.requests.ListTopicsRequest;
import com.oracle.bmc.ons.requests.UpdateTopicRequest;
import com.oracle.bmc.ons.responses.ChangeTopicCompartmentResponse;
import com.oracle.bmc.ons.responses.CreateTopicResponse;
import com.oracle.bmc.ons.responses.DeleteTopicResponse;
import com.oracle.bmc.ons.responses.GetTopicResponse;
import com.oracle.bmc.ons.responses.ListTopicsResponse;
import com.oracle.bmc.ons.responses.UpdateTopicResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationControlPlaneAsyncClient
extends BaseAsyncClient
implements NotificationControlPlaneAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NOTIFICATIONCONTROLPLANE").serviceEndpointPrefix("notification").serviceEndpointTemplate("https://notification.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(NotificationControlPlaneAsyncClient.class);

    NotificationControlPlaneAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeTopicCompartmentResponse> changeTopicCompartment(ChangeTopicCompartmentRequest request, AsyncHandler<ChangeTopicCompartmentRequest, ChangeTopicCompartmentResponse> handler) {
        Validate.notBlank((String)request.getTopicId(), (String)"topicId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeTopicCompartmentDetails(), "changeTopicCompartmentDetails is required");
        return this.clientCall(request, ChangeTopicCompartmentResponse::builder).logger(LOG, "changeTopicCompartment").serviceDetails("NotificationControlPlane", "ChangeTopicCompartment", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/NotificationTopic/ChangeTopicCompartment").method(Method.POST).requestBuilder(ChangeTopicCompartmentRequest::builder).basePath("/20181201").appendPathParam("topics").appendPathParam(request.getTopicId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeTopicCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateTopicResponse> createTopic(CreateTopicRequest request, AsyncHandler<CreateTopicRequest, CreateTopicResponse> handler) {
        Objects.requireNonNull(request.getCreateTopicDetails(), "createTopicDetails is required");
        return this.clientCall(request, CreateTopicResponse::builder).logger(LOG, "createTopic").serviceDetails("NotificationControlPlane", "CreateTopic", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/NotificationTopic/CreateTopic").method(Method.POST).requestBuilder(CreateTopicRequest::builder).basePath("/20181201").appendPathParam("topics").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(NotificationTopic.class, CreateTopicResponse.Builder::notificationTopic).handleResponseHeaderString("opc-request-id", CreateTopicResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateTopicResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteTopicResponse> deleteTopic(DeleteTopicRequest request, AsyncHandler<DeleteTopicRequest, DeleteTopicResponse> handler) {
        Validate.notBlank((String)request.getTopicId(), (String)"topicId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteTopicResponse::builder).logger(LOG, "deleteTopic").serviceDetails("NotificationControlPlane", "DeleteTopic", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/NotificationTopic/DeleteTopic").method(Method.DELETE).requestBuilder(DeleteTopicRequest::builder).basePath("/20181201").appendPathParam("topics").appendPathParam(request.getTopicId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteTopicResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTopicResponse> getTopic(GetTopicRequest request, AsyncHandler<GetTopicRequest, GetTopicResponse> handler) {
        Validate.notBlank((String)request.getTopicId(), (String)"topicId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTopicResponse::builder).logger(LOG, "getTopic").serviceDetails("NotificationControlPlane", "GetTopic", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/NotificationTopic/GetTopic").method(Method.GET).requestBuilder(GetTopicRequest::builder).basePath("/20181201").appendPathParam("topics").appendPathParam(request.getTopicId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NotificationTopic.class, GetTopicResponse.Builder::notificationTopic).handleResponseHeaderString("opc-request-id", GetTopicResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetTopicResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListTopicsResponse> listTopics(ListTopicsRequest request, AsyncHandler<ListTopicsRequest, ListTopicsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListTopicsResponse::builder).logger(LOG, "listTopics").serviceDetails("NotificationControlPlane", "ListTopics", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/NotificationTopic/ListTopics").method(Method.GET).requestBuilder(ListTopicsRequest::builder).basePath("/20181201").appendPathParam("topics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(NotificationTopicSummary.class, ListTopicsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListTopicsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListTopicsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListTopicsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateTopicResponse> updateTopic(UpdateTopicRequest request, AsyncHandler<UpdateTopicRequest, UpdateTopicResponse> handler) {
        Validate.notBlank((String)request.getTopicId(), (String)"topicId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTopicAttributesDetails(), "topicAttributesDetails is required");
        return this.clientCall(request, UpdateTopicResponse::builder).logger(LOG, "updateTopic").serviceDetails("NotificationControlPlane", "UpdateTopic", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/NotificationTopic/UpdateTopic").method(Method.PUT).requestBuilder(UpdateTopicRequest::builder).basePath("/20181201").appendPathParam("topics").appendPathParam(request.getTopicId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(NotificationTopic.class, UpdateTopicResponse.Builder::notificationTopic).handleResponseHeaderString("opc-request-id", UpdateTopicResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateTopicResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public NotificationControlPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)NotificationControlPlaneAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public NotificationControlPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(NotificationControlPlaneAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public NotificationControlPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)NotificationControlPlaneAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public NotificationControlPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)NotificationControlPlaneAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public NotificationControlPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)NotificationControlPlaneAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public NotificationControlPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)NotificationControlPlaneAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public NotificationControlPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)NotificationControlPlaneAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NotificationControlPlaneAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "ons";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"ons");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public NotificationControlPlaneAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new NotificationControlPlaneAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

