/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackoffRetryPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="maxRetryDuration")
    private final Integer maxRetryDuration;
    @JsonProperty(value="policyType")
    private final PolicyType policyType;

    @Deprecated
    @ConstructorProperties(value={"maxRetryDuration", "policyType"})
    public BackoffRetryPolicy(Integer maxRetryDuration, PolicyType policyType) {
        this.maxRetryDuration = maxRetryDuration;
        this.policyType = policyType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getMaxRetryDuration() {
        return this.maxRetryDuration;
    }

    public PolicyType getPolicyType() {
        return this.policyType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackoffRetryPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("maxRetryDuration=").append(String.valueOf(this.maxRetryDuration));
        sb.append(", policyType=").append(String.valueOf((Object)this.policyType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackoffRetryPolicy)) {
            return false;
        }
        BackoffRetryPolicy other = (BackoffRetryPolicy)((Object)o);
        return Objects.equals(this.maxRetryDuration, other.maxRetryDuration) && Objects.equals((Object)this.policyType, (Object)other.policyType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.maxRetryDuration == null ? 43 : this.maxRetryDuration.hashCode());
        result = result * 59 + (this.policyType == null ? 43 : this.policyType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PolicyType implements BmcEnum
    {
        Exponential("EXPONENTIAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PolicyType> map;

        private PolicyType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PolicyType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PolicyType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PolicyType.class);
            map = new HashMap<String, PolicyType>();
            for (PolicyType v : PolicyType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="maxRetryDuration")
        private Integer maxRetryDuration;
        @JsonProperty(value="policyType")
        private PolicyType policyType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder maxRetryDuration(Integer maxRetryDuration) {
            this.maxRetryDuration = maxRetryDuration;
            this.__explicitlySet__.add("maxRetryDuration");
            return this;
        }

        public Builder policyType(PolicyType policyType) {
            this.policyType = policyType;
            this.__explicitlySet__.add("policyType");
            return this;
        }

        public BackoffRetryPolicy build() {
            BackoffRetryPolicy model = new BackoffRetryPolicy(this.maxRetryDuration, this.policyType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackoffRetryPolicy model) {
            if (model.wasPropertyExplicitlySet("maxRetryDuration")) {
                this.maxRetryDuration(model.getMaxRetryDuration());
            }
            if (model.wasPropertyExplicitlySet("policyType")) {
                this.policyType(model.getPolicyType());
            }
            return this;
        }
    }
}

