/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.ons.NotificationDataPlane;
import com.oracle.bmc.ons.NotificationDataPlanePaginators;
import com.oracle.bmc.ons.NotificationDataPlaneWaiters;
import com.oracle.bmc.ons.model.ConfirmationResult;
import com.oracle.bmc.ons.model.PublishResult;
import com.oracle.bmc.ons.model.Subscription;
import com.oracle.bmc.ons.model.SubscriptionSummary;
import com.oracle.bmc.ons.model.UpdateSubscriptionDetails;
import com.oracle.bmc.ons.requests.ChangeSubscriptionCompartmentRequest;
import com.oracle.bmc.ons.requests.CreateSubscriptionRequest;
import com.oracle.bmc.ons.requests.DeleteSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetConfirmSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetUnsubscriptionRequest;
import com.oracle.bmc.ons.requests.ListSubscriptionsRequest;
import com.oracle.bmc.ons.requests.PublishMessageRequest;
import com.oracle.bmc.ons.requests.ResendSubscriptionConfirmationRequest;
import com.oracle.bmc.ons.requests.UpdateSubscriptionRequest;
import com.oracle.bmc.ons.responses.ChangeSubscriptionCompartmentResponse;
import com.oracle.bmc.ons.responses.CreateSubscriptionResponse;
import com.oracle.bmc.ons.responses.DeleteSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetConfirmSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetUnsubscriptionResponse;
import com.oracle.bmc.ons.responses.ListSubscriptionsResponse;
import com.oracle.bmc.ons.responses.PublishMessageResponse;
import com.oracle.bmc.ons.responses.ResendSubscriptionConfirmationResponse;
import com.oracle.bmc.ons.responses.UpdateSubscriptionResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationDataPlaneClient
extends BaseSyncClient
implements NotificationDataPlane {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NOTIFICATIONDATAPLANE").serviceEndpointPrefix("notification").serviceEndpointTemplate("https://notification.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDataPlaneClient.class);
    private final NotificationDataPlaneWaiters waiters;
    private final NotificationDataPlanePaginators paginators;

    NotificationDataPlaneClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("NotificationDataPlane-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new NotificationDataPlaneWaiters(executorService, this);
        this.paginators = new NotificationDataPlanePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeSubscriptionCompartmentResponse changeSubscriptionCompartment(ChangeSubscriptionCompartmentRequest request) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSubscriptionCompartmentDetails(), "changeSubscriptionCompartmentDetails is required");
        return (ChangeSubscriptionCompartmentResponse)this.clientCall(request, ChangeSubscriptionCompartmentResponse::builder).logger(LOG, "changeSubscriptionCompartment").serviceDetails("NotificationDataPlane", "ChangeSubscriptionCompartment", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/Subscription/ChangeSubscriptionCompartment").method(Method.POST).requestBuilder(ChangeSubscriptionCompartmentRequest::builder).basePath("/20181201").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSubscriptionCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest request) {
        Objects.requireNonNull(request.getCreateSubscriptionDetails(), "createSubscriptionDetails is required");
        return (CreateSubscriptionResponse)this.clientCall(request, CreateSubscriptionResponse::builder).logger(LOG, "createSubscription").serviceDetails("NotificationDataPlane", "CreateSubscription", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/Subscription/CreateSubscription").method(Method.POST).requestBuilder(CreateSubscriptionRequest::builder).basePath("/20181201").appendPathParam("subscriptions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Subscription.class, CreateSubscriptionResponse.Builder::subscription).handleResponseHeaderString("opc-request-id", CreateSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateSubscriptionResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteSubscriptionResponse deleteSubscription(DeleteSubscriptionRequest request) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return (DeleteSubscriptionResponse)this.clientCall(request, DeleteSubscriptionResponse::builder).logger(LOG, "deleteSubscription").serviceDetails("NotificationDataPlane", "DeleteSubscription", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/Subscription/DeleteSubscription").method(Method.DELETE).requestBuilder(DeleteSubscriptionRequest::builder).basePath("/20181201").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSubscriptionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetConfirmSubscriptionResponse getConfirmSubscription(GetConfirmSubscriptionRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getToken(), "token is required");
        Objects.requireNonNull(request.getProtocol(), "protocol is required");
        return (GetConfirmSubscriptionResponse)this.clientCall(request, GetConfirmSubscriptionResponse::builder).logger(LOG, "getConfirmSubscription").serviceDetails("NotificationDataPlane", "GetConfirmSubscription", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/Subscription/GetConfirmSubscription").method(Method.GET).requestBuilder(GetConfirmSubscriptionRequest::builder).basePath("/20181201").appendPathParam("subscriptions").appendPathParam(request.getId()).appendPathParam("confirmation").appendQueryParam("token", (Object)request.getToken()).appendQueryParam("protocol", (Object)request.getProtocol()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConfirmationResult.class, GetConfirmSubscriptionResponse.Builder::confirmationResult).handleResponseHeaderString("opc-request-id", GetConfirmSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetConfirmSubscriptionResponse.Builder::etag).callSync();
    }

    @Override
    public GetSubscriptionResponse getSubscription(GetSubscriptionRequest request) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return (GetSubscriptionResponse)this.clientCall(request, GetSubscriptionResponse::builder).logger(LOG, "getSubscription").serviceDetails("NotificationDataPlane", "GetSubscription", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/Subscription/GetSubscription").method(Method.GET).requestBuilder(GetSubscriptionRequest::builder).basePath("/20181201").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Subscription.class, GetSubscriptionResponse.Builder::subscription).handleResponseHeaderString("opc-request-id", GetSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSubscriptionResponse.Builder::etag).callSync();
    }

    @Override
    public GetUnsubscriptionResponse getUnsubscription(GetUnsubscriptionRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getToken(), "token is required");
        Objects.requireNonNull(request.getProtocol(), "protocol is required");
        return (GetUnsubscriptionResponse)this.clientCall(request, GetUnsubscriptionResponse::builder).logger(LOG, "getUnsubscription").serviceDetails("NotificationDataPlane", "GetUnsubscription", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/Subscription/GetUnsubscription").method(Method.GET).requestBuilder(GetUnsubscriptionRequest::builder).basePath("/20181201").appendPathParam("subscriptions").appendPathParam(request.getId()).appendPathParam("unsubscription").appendQueryParam("token", (Object)request.getToken()).appendQueryParam("protocol", (Object)request.getProtocol()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(String.class, GetUnsubscriptionResponse.Builder::value).handleResponseHeaderString("opc-request-id", GetUnsubscriptionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSubscriptionsResponse listSubscriptions(ListSubscriptionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSubscriptionsResponse)this.clientCall(request, ListSubscriptionsResponse::builder).logger(LOG, "listSubscriptions").serviceDetails("NotificationDataPlane", "ListSubscriptions", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/Subscription/ListSubscriptions").method(Method.GET).requestBuilder(ListSubscriptionsRequest::builder).basePath("/20181201").appendPathParam("subscriptions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("topicId", (Object)request.getTopicId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SubscriptionSummary.class, ListSubscriptionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSubscriptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public PublishMessageResponse publishMessage(PublishMessageRequest request) {
        Validate.notBlank((String)request.getTopicId(), (String)"topicId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getMessageDetails(), "messageDetails is required");
        return (PublishMessageResponse)this.clientCall(request, PublishMessageResponse::builder).logger(LOG, "publishMessage").serviceDetails("NotificationDataPlane", "PublishMessage", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/NotificationTopic/PublishMessage").method(Method.POST).requestBuilder(PublishMessageRequest::builder).basePath("/20181201").appendPathParam("topics").appendPathParam(request.getTopicId()).appendPathParam("messages").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendEnumHeader("messageType", (BmcEnum)request.getMessageType()).hasBody().handleBody(PublishResult.class, PublishMessageResponse.Builder::publishResult).handleResponseHeaderString("opc-request-id", PublishMessageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ResendSubscriptionConfirmationResponse resendSubscriptionConfirmation(ResendSubscriptionConfirmationRequest request) {
        Validate.notBlank((String)request.getId(), (String)"id must not be blank", (Object[])new Object[0]);
        return (ResendSubscriptionConfirmationResponse)this.clientCall(request, ResendSubscriptionConfirmationResponse::builder).logger(LOG, "resendSubscriptionConfirmation").serviceDetails("NotificationDataPlane", "ResendSubscriptionConfirmation", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/Subscription/ResendSubscriptionConfirmation").method(Method.POST).requestBuilder(ResendSubscriptionConfirmationRequest::builder).basePath("/20181201").appendPathParam("subscriptions").appendPathParam(request.getId()).appendPathParam("resendConfirmation").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Subscription.class, ResendSubscriptionConfirmationResponse.Builder::subscription).handleResponseHeaderString("opc-request-id", ResendSubscriptionConfirmationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSubscriptionResponse updateSubscription(UpdateSubscriptionRequest request) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSubscriptionDetails(), "updateSubscriptionDetails is required");
        return (UpdateSubscriptionResponse)this.clientCall(request, UpdateSubscriptionResponse::builder).logger(LOG, "updateSubscription").serviceDetails("NotificationDataPlane", "UpdateSubscription", "https://docs.oracle.com/iaas/api/#/en/notification/20181201/Subscription/UpdateSubscription").method(Method.PUT).requestBuilder(UpdateSubscriptionRequest::builder).basePath("/20181201").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(UpdateSubscriptionDetails.class, UpdateSubscriptionResponse.Builder::updateSubscriptionDetails).handleResponseHeaderString("opc-request-id", UpdateSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateSubscriptionResponse.Builder::etag).callSync();
    }

    @Override
    public NotificationDataPlaneWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public NotificationDataPlanePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public NotificationDataPlaneClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)NotificationDataPlaneClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public NotificationDataPlaneClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(NotificationDataPlaneClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public NotificationDataPlaneClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)NotificationDataPlaneClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)NotificationDataPlaneClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)NotificationDataPlaneClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)NotificationDataPlaneClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)NotificationDataPlaneClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public NotificationDataPlaneClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)NotificationDataPlaneClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NotificationDataPlaneClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "ons";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"ons");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public NotificationDataPlaneClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new NotificationDataPlaneClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

