/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.ons.model.UpdateSubscriptionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSubscriptionRequest
extends BmcRequest<UpdateSubscriptionDetails> {
    private String subscriptionId;
    private UpdateSubscriptionDetails updateSubscriptionDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public UpdateSubscriptionDetails getUpdateSubscriptionDetails() {
        return this.updateSubscriptionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateSubscriptionDetails getBody$() {
        return this.updateSubscriptionDetails;
    }

    public Builder toBuilder() {
        return new Builder().subscriptionId(this.subscriptionId).updateSubscriptionDetails(this.updateSubscriptionDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",updateSubscriptionDetails=").append(String.valueOf((Object)this.updateSubscriptionDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSubscriptionRequest)) {
            return false;
        }
        UpdateSubscriptionRequest other = (UpdateSubscriptionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals((Object)this.updateSubscriptionDetails, (Object)other.updateSubscriptionDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.updateSubscriptionDetails == null ? 43 : this.updateSubscriptionDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSubscriptionRequest, UpdateSubscriptionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String subscriptionId = null;
        private UpdateSubscriptionDetails updateSubscriptionDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder updateSubscriptionDetails(UpdateSubscriptionDetails updateSubscriptionDetails) {
            this.updateSubscriptionDetails = updateSubscriptionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSubscriptionRequest o) {
            this.subscriptionId(o.getSubscriptionId());
            this.updateSubscriptionDetails(o.getUpdateSubscriptionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSubscriptionRequest build() {
            UpdateSubscriptionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSubscriptionDetails body) {
            this.updateSubscriptionDetails(body);
            return this;
        }

        public UpdateSubscriptionRequest buildWithoutInvocationCallback() {
            UpdateSubscriptionRequest request = new UpdateSubscriptionRequest();
            request.subscriptionId = this.subscriptionId;
            request.updateSubscriptionDetails = this.updateSubscriptionDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

