/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opa;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.opa.OpaInstancePaginators;
import com.oracle.bmc.opa.OpaInstanceWaiters;
import com.oracle.bmc.opa.model.OpaInstance;
import com.oracle.bmc.opa.model.OpaInstanceCollection;
import com.oracle.bmc.opa.model.WorkRequest;
import com.oracle.bmc.opa.model.WorkRequestErrorCollection;
import com.oracle.bmc.opa.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.opa.model.WorkRequestSummaryCollection;
import com.oracle.bmc.opa.requests.CancelWorkRequestRequest;
import com.oracle.bmc.opa.requests.ChangeOpaInstanceCompartmentRequest;
import com.oracle.bmc.opa.requests.CreateOpaInstanceRequest;
import com.oracle.bmc.opa.requests.DeleteOpaInstanceRequest;
import com.oracle.bmc.opa.requests.GetOpaInstanceRequest;
import com.oracle.bmc.opa.requests.GetWorkRequestRequest;
import com.oracle.bmc.opa.requests.ListOpaInstancesRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.opa.requests.ListWorkRequestsRequest;
import com.oracle.bmc.opa.requests.StartOpaInstanceRequest;
import com.oracle.bmc.opa.requests.StopOpaInstanceRequest;
import com.oracle.bmc.opa.requests.UpdateOpaInstanceRequest;
import com.oracle.bmc.opa.responses.CancelWorkRequestResponse;
import com.oracle.bmc.opa.responses.ChangeOpaInstanceCompartmentResponse;
import com.oracle.bmc.opa.responses.CreateOpaInstanceResponse;
import com.oracle.bmc.opa.responses.DeleteOpaInstanceResponse;
import com.oracle.bmc.opa.responses.GetOpaInstanceResponse;
import com.oracle.bmc.opa.responses.GetWorkRequestResponse;
import com.oracle.bmc.opa.responses.ListOpaInstancesResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.opa.responses.ListWorkRequestsResponse;
import com.oracle.bmc.opa.responses.StartOpaInstanceResponse;
import com.oracle.bmc.opa.responses.StopOpaInstanceResponse;
import com.oracle.bmc.opa.responses.UpdateOpaInstanceResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpaInstanceClient
extends BaseSyncClient
implements com.oracle.bmc.opa.OpaInstance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPAINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://process.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OpaInstanceClient.class);
    private final OpaInstanceWaiters waiters;
    private final OpaInstancePaginators paginators;

    OpaInstanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("OpaInstance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OpaInstanceWaiters(executorService, this);
        this.paginators = new OpaInstancePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("OpaInstance", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeOpaInstanceCompartmentResponse changeOpaInstanceCompartment(ChangeOpaInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeOpaInstanceCompartmentDetails(), "changeOpaInstanceCompartmentDetails is required");
        return (ChangeOpaInstanceCompartmentResponse)this.clientCall(request, ChangeOpaInstanceCompartmentResponse::builder).logger(LOG, "changeOpaInstanceCompartment").serviceDetails("OpaInstance", "ChangeOpaInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/OpaInstance/ChangeOpaInstanceCompartment").method(Method.POST).requestBuilder(ChangeOpaInstanceCompartmentRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeOpaInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeOpaInstanceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateOpaInstanceResponse createOpaInstance(CreateOpaInstanceRequest request) {
        Objects.requireNonNull(request.getCreateOpaInstanceDetails(), "createOpaInstanceDetails is required");
        return (CreateOpaInstanceResponse)this.clientCall(request, CreateOpaInstanceResponse::builder).logger(LOG, "createOpaInstance").serviceDetails("OpaInstance", "CreateOpaInstance", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/OpaInstance/CreateOpaInstance").method(Method.POST).requestBuilder(CreateOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CreateOpaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOpaInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteOpaInstanceResponse deleteOpaInstance(DeleteOpaInstanceRequest request) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        return (DeleteOpaInstanceResponse)this.clientCall(request, DeleteOpaInstanceResponse::builder).logger(LOG, "deleteOpaInstance").serviceDetails("OpaInstance", "DeleteOpaInstance", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/OpaInstance/DeleteOpaInstance").method(Method.DELETE).requestBuilder(DeleteOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteOpaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOpaInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOpaInstanceResponse getOpaInstance(GetOpaInstanceRequest request) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        return (GetOpaInstanceResponse)this.clientCall(request, GetOpaInstanceResponse::builder).logger(LOG, "getOpaInstance").serviceDetails("OpaInstance", "GetOpaInstance", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/OpaInstance/GetOpaInstance").method(Method.GET).requestBuilder(GetOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OpaInstance.class, GetOpaInstanceResponse.Builder::opaInstance).handleResponseHeaderString("etag", GetOpaInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOpaInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("OpaInstance", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListOpaInstancesResponse listOpaInstances(ListOpaInstancesRequest request) {
        return (ListOpaInstancesResponse)this.clientCall(request, ListOpaInstancesResponse::builder).logger(LOG, "listOpaInstances").serviceDetails("OpaInstance", "ListOpaInstances", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/OpaInstanceCollection/ListOpaInstances").method(Method.GET).requestBuilder(ListOpaInstancesRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OpaInstanceCollection.class, ListOpaInstancesResponse.Builder::opaInstanceCollection).handleResponseHeaderString("opc-request-id", ListOpaInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOpaInstancesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("OpaInstance", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("OpaInstance", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("OpaInstance", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210621").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public StartOpaInstanceResponse startOpaInstance(StartOpaInstanceRequest request) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        return (StartOpaInstanceResponse)this.clientCall(request, StartOpaInstanceResponse::builder).logger(LOG, "startOpaInstance").serviceDetails("OpaInstance", "StartOpaInstance", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/OpaInstance/StartOpaInstance").method(Method.POST).requestBuilder(StartOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", StartOpaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartOpaInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StopOpaInstanceResponse stopOpaInstance(StopOpaInstanceRequest request) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        return (StopOpaInstanceResponse)this.clientCall(request, StopOpaInstanceResponse::builder).logger(LOG, "stopOpaInstance").serviceDetails("OpaInstance", "StopOpaInstance", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/OpaInstance/StopOpaInstance").method(Method.POST).requestBuilder(StopOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", StopOpaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopOpaInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateOpaInstanceResponse updateOpaInstance(UpdateOpaInstanceRequest request) {
        Validate.notBlank((String)request.getOpaInstanceId(), (String)"opaInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOpaInstanceDetails(), "updateOpaInstanceDetails is required");
        return (UpdateOpaInstanceResponse)this.clientCall(request, UpdateOpaInstanceResponse::builder).logger(LOG, "updateOpaInstance").serviceDetails("OpaInstance", "UpdateOpaInstance", "https://docs.oracle.com/iaas/api/#/en/opa/20210621/OpaInstance/UpdateOpaInstance").method(Method.PUT).requestBuilder(UpdateOpaInstanceRequest::builder).basePath("/20210621").appendPathParam("opaInstances").appendPathParam(request.getOpaInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateOpaInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateOpaInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public OpaInstanceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OpaInstancePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OpaInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OpaInstanceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpaInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OpaInstanceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpaInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OpaInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpaInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OpaInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpaInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OpaInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpaInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OpaInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpaInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OpaInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpaInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OpaInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OpaInstanceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "opa";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"opa");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OpaInstanceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OpaInstanceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

