/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opensearch.model.BackupState;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BackupEventDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="clusterId")
    private final String clusterId;
    @JsonProperty(value="backupState")
    private final BackupState backupState;
    @JsonProperty(value="snapshotName")
    private final String snapshotName;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="backupSize")
    private final Double backupSize;

    @Deprecated
    @ConstructorProperties(value={"clusterId", "backupState", "snapshotName", "timeStarted", "timeEnded", "backupSize"})
    public BackupEventDetails(String clusterId, BackupState backupState, String snapshotName, Date timeStarted, Date timeEnded, Double backupSize) {
        this.clusterId = clusterId;
        this.backupState = backupState;
        this.snapshotName = snapshotName;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.backupSize = backupSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public BackupState getBackupState() {
        return this.backupState;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public Double getBackupSize() {
        return this.backupSize;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BackupEventDetails(");
        sb.append("super=").append(super.toString());
        sb.append("clusterId=").append(String.valueOf(this.clusterId));
        sb.append(", backupState=").append(String.valueOf((Object)this.backupState));
        sb.append(", snapshotName=").append(String.valueOf(this.snapshotName));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", backupSize=").append(String.valueOf(this.backupSize));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupEventDetails)) {
            return false;
        }
        BackupEventDetails other = (BackupEventDetails)((Object)o);
        return Objects.equals(this.clusterId, other.clusterId) && Objects.equals((Object)this.backupState, (Object)other.backupState) && Objects.equals(this.snapshotName, other.snapshotName) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.backupSize, other.backupSize) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.clusterId == null ? 43 : this.clusterId.hashCode());
        result = result * 59 + (this.backupState == null ? 43 : this.backupState.hashCode());
        result = result * 59 + (this.snapshotName == null ? 43 : this.snapshotName.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.backupSize == null ? 43 : this.backupSize.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clusterId")
        private String clusterId;
        @JsonProperty(value="backupState")
        private BackupState backupState;
        @JsonProperty(value="snapshotName")
        private String snapshotName;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="backupSize")
        private Double backupSize;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            this.__explicitlySet__.add("clusterId");
            return this;
        }

        public Builder backupState(BackupState backupState) {
            this.backupState = backupState;
            this.__explicitlySet__.add("backupState");
            return this;
        }

        public Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            this.__explicitlySet__.add("snapshotName");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder backupSize(Double backupSize) {
            this.backupSize = backupSize;
            this.__explicitlySet__.add("backupSize");
            return this;
        }

        public BackupEventDetails build() {
            BackupEventDetails model = new BackupEventDetails(this.clusterId, this.backupState, this.snapshotName, this.timeStarted, this.timeEnded, this.backupSize);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BackupEventDetails model) {
            if (model.wasPropertyExplicitlySet("clusterId")) {
                this.clusterId(model.getClusterId());
            }
            if (model.wasPropertyExplicitlySet("backupState")) {
                this.backupState(model.getBackupState());
            }
            if (model.wasPropertyExplicitlySet("snapshotName")) {
                this.snapshotName(model.getSnapshotName());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("backupSize")) {
                this.backupSize(model.getBackupSize());
            }
            return this;
        }
    }
}

