/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.opensearch.OpensearchClusterBackupPaginators;
import com.oracle.bmc.opensearch.OpensearchClusterBackupWaiters;
import com.oracle.bmc.opensearch.model.OpensearchClusterBackup;
import com.oracle.bmc.opensearch.model.OpensearchClusterBackupCollection;
import com.oracle.bmc.opensearch.requests.DeleteOpensearchClusterBackupRequest;
import com.oracle.bmc.opensearch.requests.GetOpensearchClusterBackupRequest;
import com.oracle.bmc.opensearch.requests.ListOpensearchClusterBackupsRequest;
import com.oracle.bmc.opensearch.requests.UpdateOpensearchClusterBackupRequest;
import com.oracle.bmc.opensearch.responses.DeleteOpensearchClusterBackupResponse;
import com.oracle.bmc.opensearch.responses.GetOpensearchClusterBackupResponse;
import com.oracle.bmc.opensearch.responses.ListOpensearchClusterBackupsResponse;
import com.oracle.bmc.opensearch.responses.UpdateOpensearchClusterBackupResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpensearchClusterBackupClient
extends BaseSyncClient
implements com.oracle.bmc.opensearch.OpensearchClusterBackup {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPENSEARCHCLUSTERBACKUP").serviceEndpointPrefix("").serviceEndpointTemplate("https://search-indexing.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OpensearchClusterBackupClient.class);
    private final OpensearchClusterBackupWaiters waiters;
    private final OpensearchClusterBackupPaginators paginators;

    OpensearchClusterBackupClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("OpensearchClusterBackup-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OpensearchClusterBackupWaiters(executorService, this);
        this.paginators = new OpensearchClusterBackupPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public DeleteOpensearchClusterBackupResponse deleteOpensearchClusterBackup(DeleteOpensearchClusterBackupRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterBackupId(), (String)"opensearchClusterBackupId must not be blank", (Object[])new Object[0]);
        return (DeleteOpensearchClusterBackupResponse)this.clientCall(request, DeleteOpensearchClusterBackupResponse::builder).logger(LOG, "deleteOpensearchClusterBackup").serviceDetails("OpensearchClusterBackup", "DeleteOpensearchClusterBackup", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchClusterBackup/DeleteOpensearchClusterBackup").method(Method.DELETE).requestBuilder(DeleteOpensearchClusterBackupRequest::builder).basePath("/20180828").appendPathParam("opensearchClusterBackups").appendPathParam(request.getOpensearchClusterBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteOpensearchClusterBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOpensearchClusterBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOpensearchClusterBackupResponse getOpensearchClusterBackup(GetOpensearchClusterBackupRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterBackupId(), (String)"opensearchClusterBackupId must not be blank", (Object[])new Object[0]);
        return (GetOpensearchClusterBackupResponse)this.clientCall(request, GetOpensearchClusterBackupResponse::builder).logger(LOG, "getOpensearchClusterBackup").serviceDetails("OpensearchClusterBackup", "GetOpensearchClusterBackup", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchClusterBackup/GetOpensearchClusterBackup").method(Method.GET).requestBuilder(GetOpensearchClusterBackupRequest::builder).basePath("/20180828").appendPathParam("opensearchClusterBackups").appendPathParam(request.getOpensearchClusterBackupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OpensearchClusterBackup.class, GetOpensearchClusterBackupResponse.Builder::opensearchClusterBackup).handleResponseHeaderString("etag", GetOpensearchClusterBackupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOpensearchClusterBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListOpensearchClusterBackupsResponse listOpensearchClusterBackups(ListOpensearchClusterBackupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOpensearchClusterBackupsResponse)this.clientCall(request, ListOpensearchClusterBackupsResponse::builder).logger(LOG, "listOpensearchClusterBackups").serviceDetails("OpensearchClusterBackup", "ListOpensearchClusterBackups", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchClusterBackupCollection/ListOpensearchClusterBackups").method(Method.GET).requestBuilder(ListOpensearchClusterBackupsRequest::builder).basePath("/20180828").appendPathParam("opensearchClusterBackups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("sourceOpensearchClusterId", (Object)request.getSourceOpensearchClusterId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OpensearchClusterBackupCollection.class, ListOpensearchClusterBackupsResponse.Builder::opensearchClusterBackupCollection).handleResponseHeaderString("opc-request-id", ListOpensearchClusterBackupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOpensearchClusterBackupsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateOpensearchClusterBackupResponse updateOpensearchClusterBackup(UpdateOpensearchClusterBackupRequest request) {
        Validate.notBlank((String)request.getOpensearchClusterBackupId(), (String)"opensearchClusterBackupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOpensearchClusterBackupDetails(), "updateOpensearchClusterBackupDetails is required");
        return (UpdateOpensearchClusterBackupResponse)this.clientCall(request, UpdateOpensearchClusterBackupResponse::builder).logger(LOG, "updateOpensearchClusterBackup").serviceDetails("OpensearchClusterBackup", "UpdateOpensearchClusterBackup", "https://docs.oracle.com/iaas/api/#/en/opensearch/20180828/OpensearchClusterBackup/UpdateOpensearchClusterBackup").method(Method.PUT).requestBuilder(UpdateOpensearchClusterBackupRequest::builder).basePath("/20180828").appendPathParam("opensearchClusterBackups").appendPathParam(request.getOpensearchClusterBackupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateOpensearchClusterBackupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateOpensearchClusterBackupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public OpensearchClusterBackupWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OpensearchClusterBackupPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OpensearchClusterBackupClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OpensearchClusterBackupClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterBackupClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OpensearchClusterBackupClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterBackupClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OpensearchClusterBackupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterBackupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OpensearchClusterBackupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterBackupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OpensearchClusterBackupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterBackupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OpensearchClusterBackupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterBackupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OpensearchClusterBackupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OpensearchClusterBackupClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OpensearchClusterBackupClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OpensearchClusterBackupClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "opensearch";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"opensearch");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OpensearchClusterBackupClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OpensearchClusterBackupClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

