/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch;

import com.oracle.bmc.opensearch.OpensearchClusterBackup;
import com.oracle.bmc.opensearch.model.OpensearchClusterBackup;
import com.oracle.bmc.opensearch.requests.GetOpensearchClusterBackupRequest;
import com.oracle.bmc.opensearch.responses.GetOpensearchClusterBackupResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OpensearchClusterBackupWaiters {
    private final ExecutorService executorService;
    private final OpensearchClusterBackup client;

    public OpensearchClusterBackupWaiters(ExecutorService executorService, OpensearchClusterBackup client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOpensearchClusterBackupRequest, GetOpensearchClusterBackupResponse> forOpensearchClusterBackup(GetOpensearchClusterBackupRequest request, OpensearchClusterBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOpensearchClusterBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOpensearchClusterBackupRequest, GetOpensearchClusterBackupResponse> forOpensearchClusterBackup(GetOpensearchClusterBackupRequest request, OpensearchClusterBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOpensearchClusterBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOpensearchClusterBackupRequest, GetOpensearchClusterBackupResponse> forOpensearchClusterBackup(GetOpensearchClusterBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OpensearchClusterBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOpensearchClusterBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOpensearchClusterBackupRequest, GetOpensearchClusterBackupResponse> forOpensearchClusterBackup(BmcGenericWaiter waiter, GetOpensearchClusterBackupRequest request, OpensearchClusterBackup.LifecycleState ... targetStates) {
        final HashSet<OpensearchClusterBackup.LifecycleState> targetStatesSet = new HashSet<OpensearchClusterBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOpensearchClusterBackupRequest, GetOpensearchClusterBackupResponse>(){

            @Override
            public GetOpensearchClusterBackupResponse apply(GetOpensearchClusterBackupRequest request) {
                return OpensearchClusterBackupWaiters.this.client.getOpensearchClusterBackup(request);
            }
        }, (Predicate)new Predicate<GetOpensearchClusterBackupResponse>(){

            @Override
            public boolean test(GetOpensearchClusterBackupResponse response) {
                return targetStatesSet.contains((Object)response.getOpensearchClusterBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OpensearchClusterBackup.LifecycleState.Deleted)), (Object)request);
    }
}

