/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch;

import com.oracle.bmc.opensearch.OpensearchCluster;
import com.oracle.bmc.opensearch.model.OpensearchClusterSummary;
import com.oracle.bmc.opensearch.model.OpensearchVersionsSummary;
import com.oracle.bmc.opensearch.model.WorkRequest;
import com.oracle.bmc.opensearch.model.WorkRequestError;
import com.oracle.bmc.opensearch.model.WorkRequestLogEntry;
import com.oracle.bmc.opensearch.requests.ListOpensearchClustersRequest;
import com.oracle.bmc.opensearch.requests.ListOpensearchVersionsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestsRequest;
import com.oracle.bmc.opensearch.responses.ListOpensearchClustersResponse;
import com.oracle.bmc.opensearch.responses.ListOpensearchVersionsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OpensearchClusterPaginators {
    private final OpensearchCluster client;

    public OpensearchClusterPaginators(OpensearchCluster client) {
        this.client = client;
    }

    public Iterable<ListOpensearchClustersResponse> listOpensearchClustersResponseIterator(final ListOpensearchClustersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOpensearchClustersRequest.Builder>(){

            @Override
            public ListOpensearchClustersRequest.Builder get() {
                return ListOpensearchClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOpensearchClustersResponse, String>(){

            @Override
            public String apply(ListOpensearchClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOpensearchClustersRequest.Builder>, ListOpensearchClustersRequest>(){

            @Override
            public ListOpensearchClustersRequest apply(RequestBuilderAndToken<ListOpensearchClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOpensearchClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOpensearchClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOpensearchClustersRequest, ListOpensearchClustersResponse>(){

            @Override
            public ListOpensearchClustersResponse apply(ListOpensearchClustersRequest request) {
                return OpensearchClusterPaginators.this.client.listOpensearchClusters(request);
            }
        });
    }

    public Iterable<OpensearchClusterSummary> listOpensearchClustersRecordIterator(final ListOpensearchClustersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOpensearchClustersRequest.Builder>(){

            @Override
            public ListOpensearchClustersRequest.Builder get() {
                return ListOpensearchClustersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOpensearchClustersResponse, String>(){

            @Override
            public String apply(ListOpensearchClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOpensearchClustersRequest.Builder>, ListOpensearchClustersRequest>(){

            @Override
            public ListOpensearchClustersRequest apply(RequestBuilderAndToken<ListOpensearchClustersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOpensearchClustersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOpensearchClustersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOpensearchClustersRequest, ListOpensearchClustersResponse>(){

            @Override
            public ListOpensearchClustersResponse apply(ListOpensearchClustersRequest request) {
                return OpensearchClusterPaginators.this.client.listOpensearchClusters(request);
            }
        }, (Function)new Function<ListOpensearchClustersResponse, List<OpensearchClusterSummary>>(){

            @Override
            public List<OpensearchClusterSummary> apply(ListOpensearchClustersResponse response) {
                return response.getOpensearchClusterCollection().getItems();
            }
        });
    }

    public Iterable<ListOpensearchVersionsResponse> listOpensearchVersionsResponseIterator(final ListOpensearchVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOpensearchVersionsRequest.Builder>(){

            @Override
            public ListOpensearchVersionsRequest.Builder get() {
                return ListOpensearchVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOpensearchVersionsResponse, String>(){

            @Override
            public String apply(ListOpensearchVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOpensearchVersionsRequest.Builder>, ListOpensearchVersionsRequest>(){

            @Override
            public ListOpensearchVersionsRequest apply(RequestBuilderAndToken<ListOpensearchVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOpensearchVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOpensearchVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOpensearchVersionsRequest, ListOpensearchVersionsResponse>(){

            @Override
            public ListOpensearchVersionsResponse apply(ListOpensearchVersionsRequest request) {
                return OpensearchClusterPaginators.this.client.listOpensearchVersions(request);
            }
        });
    }

    public Iterable<OpensearchVersionsSummary> listOpensearchVersionsRecordIterator(final ListOpensearchVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOpensearchVersionsRequest.Builder>(){

            @Override
            public ListOpensearchVersionsRequest.Builder get() {
                return ListOpensearchVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOpensearchVersionsResponse, String>(){

            @Override
            public String apply(ListOpensearchVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOpensearchVersionsRequest.Builder>, ListOpensearchVersionsRequest>(){

            @Override
            public ListOpensearchVersionsRequest apply(RequestBuilderAndToken<ListOpensearchVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOpensearchVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOpensearchVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOpensearchVersionsRequest, ListOpensearchVersionsResponse>(){

            @Override
            public ListOpensearchVersionsResponse apply(ListOpensearchVersionsRequest request) {
                return OpensearchClusterPaginators.this.client.listOpensearchVersions(request);
            }
        }, (Function)new Function<ListOpensearchVersionsResponse, List<OpensearchVersionsSummary>>(){

            @Override
            public List<OpensearchVersionsSummary> apply(ListOpensearchVersionsResponse response) {
                return response.getOpensearchVersionsCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OpensearchClusterPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OpensearchClusterPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OpensearchClusterPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OpensearchClusterPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OpensearchClusterPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OpensearchClusterPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            @Override
            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

