/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opensearch.model.DataNodeHostType;
import com.oracle.bmc.opensearch.model.MasterNodeHostType;
import com.oracle.bmc.opensearch.model.SecurityMode;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OpensearchCluster
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeDeleted")
    private final Date timeDeleted;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="softwareVersion")
    private final String softwareVersion;
    @JsonProperty(value="totalStorageGB")
    private final Integer totalStorageGB;
    @JsonProperty(value="opensearchFqdn")
    private final String opensearchFqdn;
    @JsonProperty(value="opensearchPrivateIp")
    private final String opensearchPrivateIp;
    @JsonProperty(value="opendashboardFqdn")
    private final String opendashboardFqdn;
    @JsonProperty(value="opendashboardPrivateIp")
    private final String opendashboardPrivateIp;
    @JsonProperty(value="masterNodeCount")
    private final Integer masterNodeCount;
    @JsonProperty(value="masterNodeHostType")
    private final MasterNodeHostType masterNodeHostType;
    @JsonProperty(value="masterNodeHostBareMetalShape")
    private final String masterNodeHostBareMetalShape;
    @JsonProperty(value="masterNodeHostOcpuCount")
    private final Integer masterNodeHostOcpuCount;
    @JsonProperty(value="masterNodeHostMemoryGB")
    private final Integer masterNodeHostMemoryGB;
    @JsonProperty(value="dataNodeCount")
    private final Integer dataNodeCount;
    @JsonProperty(value="dataNodeHostType")
    private final DataNodeHostType dataNodeHostType;
    @JsonProperty(value="dataNodeHostBareMetalShape")
    private final String dataNodeHostBareMetalShape;
    @JsonProperty(value="dataNodeHostOcpuCount")
    private final Integer dataNodeHostOcpuCount;
    @JsonProperty(value="dataNodeHostMemoryGB")
    private final Integer dataNodeHostMemoryGB;
    @JsonProperty(value="dataNodeStorageGB")
    private final Integer dataNodeStorageGB;
    @JsonProperty(value="opendashboardNodeCount")
    private final Integer opendashboardNodeCount;
    @JsonProperty(value="opendashboardNodeHostOcpuCount")
    private final Integer opendashboardNodeHostOcpuCount;
    @JsonProperty(value="opendashboardNodeHostMemoryGB")
    private final Integer opendashboardNodeHostMemoryGB;
    @JsonProperty(value="vcnId")
    private final String vcnId;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="vcnCompartmentId")
    private final String vcnCompartmentId;
    @JsonProperty(value="subnetCompartmentId")
    private final String subnetCompartmentId;
    @JsonProperty(value="fqdn")
    private final String fqdn;
    @JsonProperty(value="availabilityDomains")
    private final List<String> availabilityDomains;
    @JsonProperty(value="securityMode")
    private final SecurityMode securityMode;
    @JsonProperty(value="securityMasterUserName")
    private final String securityMasterUserName;
    @JsonProperty(value="securityMasterUserPasswordHash")
    private final String securityMasterUserPasswordHash;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "lifecycleState", "timeCreated", "timeUpdated", "timeDeleted", "lifecycleDetails", "freeformTags", "definedTags", "systemTags", "softwareVersion", "totalStorageGB", "opensearchFqdn", "opensearchPrivateIp", "opendashboardFqdn", "opendashboardPrivateIp", "masterNodeCount", "masterNodeHostType", "masterNodeHostBareMetalShape", "masterNodeHostOcpuCount", "masterNodeHostMemoryGB", "dataNodeCount", "dataNodeHostType", "dataNodeHostBareMetalShape", "dataNodeHostOcpuCount", "dataNodeHostMemoryGB", "dataNodeStorageGB", "opendashboardNodeCount", "opendashboardNodeHostOcpuCount", "opendashboardNodeHostMemoryGB", "vcnId", "subnetId", "vcnCompartmentId", "subnetCompartmentId", "fqdn", "availabilityDomains", "securityMode", "securityMasterUserName", "securityMasterUserPasswordHash"})
    public OpensearchCluster(String id, String displayName, String compartmentId, LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, Date timeDeleted, String lifecycleDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String softwareVersion, Integer totalStorageGB, String opensearchFqdn, String opensearchPrivateIp, String opendashboardFqdn, String opendashboardPrivateIp, Integer masterNodeCount, MasterNodeHostType masterNodeHostType, String masterNodeHostBareMetalShape, Integer masterNodeHostOcpuCount, Integer masterNodeHostMemoryGB, Integer dataNodeCount, DataNodeHostType dataNodeHostType, String dataNodeHostBareMetalShape, Integer dataNodeHostOcpuCount, Integer dataNodeHostMemoryGB, Integer dataNodeStorageGB, Integer opendashboardNodeCount, Integer opendashboardNodeHostOcpuCount, Integer opendashboardNodeHostMemoryGB, String vcnId, String subnetId, String vcnCompartmentId, String subnetCompartmentId, String fqdn, List<String> availabilityDomains, SecurityMode securityMode, String securityMasterUserName, String securityMasterUserPasswordHash) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.timeDeleted = timeDeleted;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.softwareVersion = softwareVersion;
        this.totalStorageGB = totalStorageGB;
        this.opensearchFqdn = opensearchFqdn;
        this.opensearchPrivateIp = opensearchPrivateIp;
        this.opendashboardFqdn = opendashboardFqdn;
        this.opendashboardPrivateIp = opendashboardPrivateIp;
        this.masterNodeCount = masterNodeCount;
        this.masterNodeHostType = masterNodeHostType;
        this.masterNodeHostBareMetalShape = masterNodeHostBareMetalShape;
        this.masterNodeHostOcpuCount = masterNodeHostOcpuCount;
        this.masterNodeHostMemoryGB = masterNodeHostMemoryGB;
        this.dataNodeCount = dataNodeCount;
        this.dataNodeHostType = dataNodeHostType;
        this.dataNodeHostBareMetalShape = dataNodeHostBareMetalShape;
        this.dataNodeHostOcpuCount = dataNodeHostOcpuCount;
        this.dataNodeHostMemoryGB = dataNodeHostMemoryGB;
        this.dataNodeStorageGB = dataNodeStorageGB;
        this.opendashboardNodeCount = opendashboardNodeCount;
        this.opendashboardNodeHostOcpuCount = opendashboardNodeHostOcpuCount;
        this.opendashboardNodeHostMemoryGB = opendashboardNodeHostMemoryGB;
        this.vcnId = vcnId;
        this.subnetId = subnetId;
        this.vcnCompartmentId = vcnCompartmentId;
        this.subnetCompartmentId = subnetCompartmentId;
        this.fqdn = fqdn;
        this.availabilityDomains = availabilityDomains;
        this.securityMode = securityMode;
        this.securityMasterUserName = securityMasterUserName;
        this.securityMasterUserPasswordHash = securityMasterUserPasswordHash;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeDeleted() {
        return this.timeDeleted;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public Integer getTotalStorageGB() {
        return this.totalStorageGB;
    }

    public String getOpensearchFqdn() {
        return this.opensearchFqdn;
    }

    public String getOpensearchPrivateIp() {
        return this.opensearchPrivateIp;
    }

    public String getOpendashboardFqdn() {
        return this.opendashboardFqdn;
    }

    public String getOpendashboardPrivateIp() {
        return this.opendashboardPrivateIp;
    }

    public Integer getMasterNodeCount() {
        return this.masterNodeCount;
    }

    public MasterNodeHostType getMasterNodeHostType() {
        return this.masterNodeHostType;
    }

    public String getMasterNodeHostBareMetalShape() {
        return this.masterNodeHostBareMetalShape;
    }

    public Integer getMasterNodeHostOcpuCount() {
        return this.masterNodeHostOcpuCount;
    }

    public Integer getMasterNodeHostMemoryGB() {
        return this.masterNodeHostMemoryGB;
    }

    public Integer getDataNodeCount() {
        return this.dataNodeCount;
    }

    public DataNodeHostType getDataNodeHostType() {
        return this.dataNodeHostType;
    }

    public String getDataNodeHostBareMetalShape() {
        return this.dataNodeHostBareMetalShape;
    }

    public Integer getDataNodeHostOcpuCount() {
        return this.dataNodeHostOcpuCount;
    }

    public Integer getDataNodeHostMemoryGB() {
        return this.dataNodeHostMemoryGB;
    }

    public Integer getDataNodeStorageGB() {
        return this.dataNodeStorageGB;
    }

    public Integer getOpendashboardNodeCount() {
        return this.opendashboardNodeCount;
    }

    public Integer getOpendashboardNodeHostOcpuCount() {
        return this.opendashboardNodeHostOcpuCount;
    }

    public Integer getOpendashboardNodeHostMemoryGB() {
        return this.opendashboardNodeHostMemoryGB;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getVcnCompartmentId() {
        return this.vcnCompartmentId;
    }

    public String getSubnetCompartmentId() {
        return this.subnetCompartmentId;
    }

    public String getFqdn() {
        return this.fqdn;
    }

    public List<String> getAvailabilityDomains() {
        return this.availabilityDomains;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public String getSecurityMasterUserName() {
        return this.securityMasterUserName;
    }

    public String getSecurityMasterUserPasswordHash() {
        return this.securityMasterUserPasswordHash;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OpensearchCluster(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeDeleted=").append(String.valueOf(this.timeDeleted));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", softwareVersion=").append(String.valueOf(this.softwareVersion));
        sb.append(", totalStorageGB=").append(String.valueOf(this.totalStorageGB));
        sb.append(", opensearchFqdn=").append(String.valueOf(this.opensearchFqdn));
        sb.append(", opensearchPrivateIp=").append(String.valueOf(this.opensearchPrivateIp));
        sb.append(", opendashboardFqdn=").append(String.valueOf(this.opendashboardFqdn));
        sb.append(", opendashboardPrivateIp=").append(String.valueOf(this.opendashboardPrivateIp));
        sb.append(", masterNodeCount=").append(String.valueOf(this.masterNodeCount));
        sb.append(", masterNodeHostType=").append(String.valueOf((Object)this.masterNodeHostType));
        sb.append(", masterNodeHostBareMetalShape=").append(String.valueOf(this.masterNodeHostBareMetalShape));
        sb.append(", masterNodeHostOcpuCount=").append(String.valueOf(this.masterNodeHostOcpuCount));
        sb.append(", masterNodeHostMemoryGB=").append(String.valueOf(this.masterNodeHostMemoryGB));
        sb.append(", dataNodeCount=").append(String.valueOf(this.dataNodeCount));
        sb.append(", dataNodeHostType=").append(String.valueOf((Object)this.dataNodeHostType));
        sb.append(", dataNodeHostBareMetalShape=").append(String.valueOf(this.dataNodeHostBareMetalShape));
        sb.append(", dataNodeHostOcpuCount=").append(String.valueOf(this.dataNodeHostOcpuCount));
        sb.append(", dataNodeHostMemoryGB=").append(String.valueOf(this.dataNodeHostMemoryGB));
        sb.append(", dataNodeStorageGB=").append(String.valueOf(this.dataNodeStorageGB));
        sb.append(", opendashboardNodeCount=").append(String.valueOf(this.opendashboardNodeCount));
        sb.append(", opendashboardNodeHostOcpuCount=").append(String.valueOf(this.opendashboardNodeHostOcpuCount));
        sb.append(", opendashboardNodeHostMemoryGB=").append(String.valueOf(this.opendashboardNodeHostMemoryGB));
        sb.append(", vcnId=").append(String.valueOf(this.vcnId));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", vcnCompartmentId=").append(String.valueOf(this.vcnCompartmentId));
        sb.append(", subnetCompartmentId=").append(String.valueOf(this.subnetCompartmentId));
        sb.append(", fqdn=").append(String.valueOf(this.fqdn));
        sb.append(", availabilityDomains=").append(String.valueOf(this.availabilityDomains));
        sb.append(", securityMode=").append(String.valueOf((Object)this.securityMode));
        sb.append(", securityMasterUserName=").append(String.valueOf(this.securityMasterUserName));
        sb.append(", securityMasterUserPasswordHash=").append(String.valueOf(this.securityMasterUserPasswordHash));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpensearchCluster)) {
            return false;
        }
        OpensearchCluster other = (OpensearchCluster)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeDeleted, other.timeDeleted) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.softwareVersion, other.softwareVersion) && Objects.equals(this.totalStorageGB, other.totalStorageGB) && Objects.equals(this.opensearchFqdn, other.opensearchFqdn) && Objects.equals(this.opensearchPrivateIp, other.opensearchPrivateIp) && Objects.equals(this.opendashboardFqdn, other.opendashboardFqdn) && Objects.equals(this.opendashboardPrivateIp, other.opendashboardPrivateIp) && Objects.equals(this.masterNodeCount, other.masterNodeCount) && Objects.equals((Object)this.masterNodeHostType, (Object)other.masterNodeHostType) && Objects.equals(this.masterNodeHostBareMetalShape, other.masterNodeHostBareMetalShape) && Objects.equals(this.masterNodeHostOcpuCount, other.masterNodeHostOcpuCount) && Objects.equals(this.masterNodeHostMemoryGB, other.masterNodeHostMemoryGB) && Objects.equals(this.dataNodeCount, other.dataNodeCount) && Objects.equals((Object)this.dataNodeHostType, (Object)other.dataNodeHostType) && Objects.equals(this.dataNodeHostBareMetalShape, other.dataNodeHostBareMetalShape) && Objects.equals(this.dataNodeHostOcpuCount, other.dataNodeHostOcpuCount) && Objects.equals(this.dataNodeHostMemoryGB, other.dataNodeHostMemoryGB) && Objects.equals(this.dataNodeStorageGB, other.dataNodeStorageGB) && Objects.equals(this.opendashboardNodeCount, other.opendashboardNodeCount) && Objects.equals(this.opendashboardNodeHostOcpuCount, other.opendashboardNodeHostOcpuCount) && Objects.equals(this.opendashboardNodeHostMemoryGB, other.opendashboardNodeHostMemoryGB) && Objects.equals(this.vcnId, other.vcnId) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.vcnCompartmentId, other.vcnCompartmentId) && Objects.equals(this.subnetCompartmentId, other.subnetCompartmentId) && Objects.equals(this.fqdn, other.fqdn) && Objects.equals(this.availabilityDomains, other.availabilityDomains) && Objects.equals((Object)this.securityMode, (Object)other.securityMode) && Objects.equals(this.securityMasterUserName, other.securityMasterUserName) && Objects.equals(this.securityMasterUserPasswordHash, other.securityMasterUserPasswordHash) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeDeleted == null ? 43 : this.timeDeleted.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.softwareVersion == null ? 43 : this.softwareVersion.hashCode());
        result = result * 59 + (this.totalStorageGB == null ? 43 : this.totalStorageGB.hashCode());
        result = result * 59 + (this.opensearchFqdn == null ? 43 : this.opensearchFqdn.hashCode());
        result = result * 59 + (this.opensearchPrivateIp == null ? 43 : this.opensearchPrivateIp.hashCode());
        result = result * 59 + (this.opendashboardFqdn == null ? 43 : this.opendashboardFqdn.hashCode());
        result = result * 59 + (this.opendashboardPrivateIp == null ? 43 : this.opendashboardPrivateIp.hashCode());
        result = result * 59 + (this.masterNodeCount == null ? 43 : this.masterNodeCount.hashCode());
        result = result * 59 + (this.masterNodeHostType == null ? 43 : this.masterNodeHostType.hashCode());
        result = result * 59 + (this.masterNodeHostBareMetalShape == null ? 43 : this.masterNodeHostBareMetalShape.hashCode());
        result = result * 59 + (this.masterNodeHostOcpuCount == null ? 43 : this.masterNodeHostOcpuCount.hashCode());
        result = result * 59 + (this.masterNodeHostMemoryGB == null ? 43 : this.masterNodeHostMemoryGB.hashCode());
        result = result * 59 + (this.dataNodeCount == null ? 43 : this.dataNodeCount.hashCode());
        result = result * 59 + (this.dataNodeHostType == null ? 43 : this.dataNodeHostType.hashCode());
        result = result * 59 + (this.dataNodeHostBareMetalShape == null ? 43 : this.dataNodeHostBareMetalShape.hashCode());
        result = result * 59 + (this.dataNodeHostOcpuCount == null ? 43 : this.dataNodeHostOcpuCount.hashCode());
        result = result * 59 + (this.dataNodeHostMemoryGB == null ? 43 : this.dataNodeHostMemoryGB.hashCode());
        result = result * 59 + (this.dataNodeStorageGB == null ? 43 : this.dataNodeStorageGB.hashCode());
        result = result * 59 + (this.opendashboardNodeCount == null ? 43 : this.opendashboardNodeCount.hashCode());
        result = result * 59 + (this.opendashboardNodeHostOcpuCount == null ? 43 : this.opendashboardNodeHostOcpuCount.hashCode());
        result = result * 59 + (this.opendashboardNodeHostMemoryGB == null ? 43 : this.opendashboardNodeHostMemoryGB.hashCode());
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.vcnCompartmentId == null ? 43 : this.vcnCompartmentId.hashCode());
        result = result * 59 + (this.subnetCompartmentId == null ? 43 : this.subnetCompartmentId.hashCode());
        result = result * 59 + (this.fqdn == null ? 43 : this.fqdn.hashCode());
        result = result * 59 + (this.availabilityDomains == null ? 43 : this.availabilityDomains.hashCode());
        result = result * 59 + (this.securityMode == null ? 43 : this.securityMode.hashCode());
        result = result * 59 + (this.securityMasterUserName == null ? 43 : this.securityMasterUserName.hashCode());
        result = result * 59 + (this.securityMasterUserPasswordHash == null ? 43 : this.securityMasterUserPasswordHash.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Creating("CREATING"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeDeleted")
        private Date timeDeleted;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="softwareVersion")
        private String softwareVersion;
        @JsonProperty(value="totalStorageGB")
        private Integer totalStorageGB;
        @JsonProperty(value="opensearchFqdn")
        private String opensearchFqdn;
        @JsonProperty(value="opensearchPrivateIp")
        private String opensearchPrivateIp;
        @JsonProperty(value="opendashboardFqdn")
        private String opendashboardFqdn;
        @JsonProperty(value="opendashboardPrivateIp")
        private String opendashboardPrivateIp;
        @JsonProperty(value="masterNodeCount")
        private Integer masterNodeCount;
        @JsonProperty(value="masterNodeHostType")
        private MasterNodeHostType masterNodeHostType;
        @JsonProperty(value="masterNodeHostBareMetalShape")
        private String masterNodeHostBareMetalShape;
        @JsonProperty(value="masterNodeHostOcpuCount")
        private Integer masterNodeHostOcpuCount;
        @JsonProperty(value="masterNodeHostMemoryGB")
        private Integer masterNodeHostMemoryGB;
        @JsonProperty(value="dataNodeCount")
        private Integer dataNodeCount;
        @JsonProperty(value="dataNodeHostType")
        private DataNodeHostType dataNodeHostType;
        @JsonProperty(value="dataNodeHostBareMetalShape")
        private String dataNodeHostBareMetalShape;
        @JsonProperty(value="dataNodeHostOcpuCount")
        private Integer dataNodeHostOcpuCount;
        @JsonProperty(value="dataNodeHostMemoryGB")
        private Integer dataNodeHostMemoryGB;
        @JsonProperty(value="dataNodeStorageGB")
        private Integer dataNodeStorageGB;
        @JsonProperty(value="opendashboardNodeCount")
        private Integer opendashboardNodeCount;
        @JsonProperty(value="opendashboardNodeHostOcpuCount")
        private Integer opendashboardNodeHostOcpuCount;
        @JsonProperty(value="opendashboardNodeHostMemoryGB")
        private Integer opendashboardNodeHostMemoryGB;
        @JsonProperty(value="vcnId")
        private String vcnId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="vcnCompartmentId")
        private String vcnCompartmentId;
        @JsonProperty(value="subnetCompartmentId")
        private String subnetCompartmentId;
        @JsonProperty(value="fqdn")
        private String fqdn;
        @JsonProperty(value="availabilityDomains")
        private List<String> availabilityDomains;
        @JsonProperty(value="securityMode")
        private SecurityMode securityMode;
        @JsonProperty(value="securityMasterUserName")
        private String securityMasterUserName;
        @JsonProperty(value="securityMasterUserPasswordHash")
        private String securityMasterUserPasswordHash;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeDeleted(Date timeDeleted) {
            this.timeDeleted = timeDeleted;
            this.__explicitlySet__.add("timeDeleted");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            this.__explicitlySet__.add("softwareVersion");
            return this;
        }

        public Builder totalStorageGB(Integer totalStorageGB) {
            this.totalStorageGB = totalStorageGB;
            this.__explicitlySet__.add("totalStorageGB");
            return this;
        }

        public Builder opensearchFqdn(String opensearchFqdn) {
            this.opensearchFqdn = opensearchFqdn;
            this.__explicitlySet__.add("opensearchFqdn");
            return this;
        }

        public Builder opensearchPrivateIp(String opensearchPrivateIp) {
            this.opensearchPrivateIp = opensearchPrivateIp;
            this.__explicitlySet__.add("opensearchPrivateIp");
            return this;
        }

        public Builder opendashboardFqdn(String opendashboardFqdn) {
            this.opendashboardFqdn = opendashboardFqdn;
            this.__explicitlySet__.add("opendashboardFqdn");
            return this;
        }

        public Builder opendashboardPrivateIp(String opendashboardPrivateIp) {
            this.opendashboardPrivateIp = opendashboardPrivateIp;
            this.__explicitlySet__.add("opendashboardPrivateIp");
            return this;
        }

        public Builder masterNodeCount(Integer masterNodeCount) {
            this.masterNodeCount = masterNodeCount;
            this.__explicitlySet__.add("masterNodeCount");
            return this;
        }

        public Builder masterNodeHostType(MasterNodeHostType masterNodeHostType) {
            this.masterNodeHostType = masterNodeHostType;
            this.__explicitlySet__.add("masterNodeHostType");
            return this;
        }

        public Builder masterNodeHostBareMetalShape(String masterNodeHostBareMetalShape) {
            this.masterNodeHostBareMetalShape = masterNodeHostBareMetalShape;
            this.__explicitlySet__.add("masterNodeHostBareMetalShape");
            return this;
        }

        public Builder masterNodeHostOcpuCount(Integer masterNodeHostOcpuCount) {
            this.masterNodeHostOcpuCount = masterNodeHostOcpuCount;
            this.__explicitlySet__.add("masterNodeHostOcpuCount");
            return this;
        }

        public Builder masterNodeHostMemoryGB(Integer masterNodeHostMemoryGB) {
            this.masterNodeHostMemoryGB = masterNodeHostMemoryGB;
            this.__explicitlySet__.add("masterNodeHostMemoryGB");
            return this;
        }

        public Builder dataNodeCount(Integer dataNodeCount) {
            this.dataNodeCount = dataNodeCount;
            this.__explicitlySet__.add("dataNodeCount");
            return this;
        }

        public Builder dataNodeHostType(DataNodeHostType dataNodeHostType) {
            this.dataNodeHostType = dataNodeHostType;
            this.__explicitlySet__.add("dataNodeHostType");
            return this;
        }

        public Builder dataNodeHostBareMetalShape(String dataNodeHostBareMetalShape) {
            this.dataNodeHostBareMetalShape = dataNodeHostBareMetalShape;
            this.__explicitlySet__.add("dataNodeHostBareMetalShape");
            return this;
        }

        public Builder dataNodeHostOcpuCount(Integer dataNodeHostOcpuCount) {
            this.dataNodeHostOcpuCount = dataNodeHostOcpuCount;
            this.__explicitlySet__.add("dataNodeHostOcpuCount");
            return this;
        }

        public Builder dataNodeHostMemoryGB(Integer dataNodeHostMemoryGB) {
            this.dataNodeHostMemoryGB = dataNodeHostMemoryGB;
            this.__explicitlySet__.add("dataNodeHostMemoryGB");
            return this;
        }

        public Builder dataNodeStorageGB(Integer dataNodeStorageGB) {
            this.dataNodeStorageGB = dataNodeStorageGB;
            this.__explicitlySet__.add("dataNodeStorageGB");
            return this;
        }

        public Builder opendashboardNodeCount(Integer opendashboardNodeCount) {
            this.opendashboardNodeCount = opendashboardNodeCount;
            this.__explicitlySet__.add("opendashboardNodeCount");
            return this;
        }

        public Builder opendashboardNodeHostOcpuCount(Integer opendashboardNodeHostOcpuCount) {
            this.opendashboardNodeHostOcpuCount = opendashboardNodeHostOcpuCount;
            this.__explicitlySet__.add("opendashboardNodeHostOcpuCount");
            return this;
        }

        public Builder opendashboardNodeHostMemoryGB(Integer opendashboardNodeHostMemoryGB) {
            this.opendashboardNodeHostMemoryGB = opendashboardNodeHostMemoryGB;
            this.__explicitlySet__.add("opendashboardNodeHostMemoryGB");
            return this;
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            this.__explicitlySet__.add("vcnId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder vcnCompartmentId(String vcnCompartmentId) {
            this.vcnCompartmentId = vcnCompartmentId;
            this.__explicitlySet__.add("vcnCompartmentId");
            return this;
        }

        public Builder subnetCompartmentId(String subnetCompartmentId) {
            this.subnetCompartmentId = subnetCompartmentId;
            this.__explicitlySet__.add("subnetCompartmentId");
            return this;
        }

        public Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            this.__explicitlySet__.add("fqdn");
            return this;
        }

        public Builder availabilityDomains(List<String> availabilityDomains) {
            this.availabilityDomains = availabilityDomains;
            this.__explicitlySet__.add("availabilityDomains");
            return this;
        }

        public Builder securityMode(SecurityMode securityMode) {
            this.securityMode = securityMode;
            this.__explicitlySet__.add("securityMode");
            return this;
        }

        public Builder securityMasterUserName(String securityMasterUserName) {
            this.securityMasterUserName = securityMasterUserName;
            this.__explicitlySet__.add("securityMasterUserName");
            return this;
        }

        public Builder securityMasterUserPasswordHash(String securityMasterUserPasswordHash) {
            this.securityMasterUserPasswordHash = securityMasterUserPasswordHash;
            this.__explicitlySet__.add("securityMasterUserPasswordHash");
            return this;
        }

        public OpensearchCluster build() {
            OpensearchCluster model = new OpensearchCluster(this.id, this.displayName, this.compartmentId, this.lifecycleState, this.timeCreated, this.timeUpdated, this.timeDeleted, this.lifecycleDetails, this.freeformTags, this.definedTags, this.systemTags, this.softwareVersion, this.totalStorageGB, this.opensearchFqdn, this.opensearchPrivateIp, this.opendashboardFqdn, this.opendashboardPrivateIp, this.masterNodeCount, this.masterNodeHostType, this.masterNodeHostBareMetalShape, this.masterNodeHostOcpuCount, this.masterNodeHostMemoryGB, this.dataNodeCount, this.dataNodeHostType, this.dataNodeHostBareMetalShape, this.dataNodeHostOcpuCount, this.dataNodeHostMemoryGB, this.dataNodeStorageGB, this.opendashboardNodeCount, this.opendashboardNodeHostOcpuCount, this.opendashboardNodeHostMemoryGB, this.vcnId, this.subnetId, this.vcnCompartmentId, this.subnetCompartmentId, this.fqdn, this.availabilityDomains, this.securityMode, this.securityMasterUserName, this.securityMasterUserPasswordHash);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OpensearchCluster model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeDeleted")) {
                this.timeDeleted(model.getTimeDeleted());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("softwareVersion")) {
                this.softwareVersion(model.getSoftwareVersion());
            }
            if (model.wasPropertyExplicitlySet("totalStorageGB")) {
                this.totalStorageGB(model.getTotalStorageGB());
            }
            if (model.wasPropertyExplicitlySet("opensearchFqdn")) {
                this.opensearchFqdn(model.getOpensearchFqdn());
            }
            if (model.wasPropertyExplicitlySet("opensearchPrivateIp")) {
                this.opensearchPrivateIp(model.getOpensearchPrivateIp());
            }
            if (model.wasPropertyExplicitlySet("opendashboardFqdn")) {
                this.opendashboardFqdn(model.getOpendashboardFqdn());
            }
            if (model.wasPropertyExplicitlySet("opendashboardPrivateIp")) {
                this.opendashboardPrivateIp(model.getOpendashboardPrivateIp());
            }
            if (model.wasPropertyExplicitlySet("masterNodeCount")) {
                this.masterNodeCount(model.getMasterNodeCount());
            }
            if (model.wasPropertyExplicitlySet("masterNodeHostType")) {
                this.masterNodeHostType(model.getMasterNodeHostType());
            }
            if (model.wasPropertyExplicitlySet("masterNodeHostBareMetalShape")) {
                this.masterNodeHostBareMetalShape(model.getMasterNodeHostBareMetalShape());
            }
            if (model.wasPropertyExplicitlySet("masterNodeHostOcpuCount")) {
                this.masterNodeHostOcpuCount(model.getMasterNodeHostOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("masterNodeHostMemoryGB")) {
                this.masterNodeHostMemoryGB(model.getMasterNodeHostMemoryGB());
            }
            if (model.wasPropertyExplicitlySet("dataNodeCount")) {
                this.dataNodeCount(model.getDataNodeCount());
            }
            if (model.wasPropertyExplicitlySet("dataNodeHostType")) {
                this.dataNodeHostType(model.getDataNodeHostType());
            }
            if (model.wasPropertyExplicitlySet("dataNodeHostBareMetalShape")) {
                this.dataNodeHostBareMetalShape(model.getDataNodeHostBareMetalShape());
            }
            if (model.wasPropertyExplicitlySet("dataNodeHostOcpuCount")) {
                this.dataNodeHostOcpuCount(model.getDataNodeHostOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("dataNodeHostMemoryGB")) {
                this.dataNodeHostMemoryGB(model.getDataNodeHostMemoryGB());
            }
            if (model.wasPropertyExplicitlySet("dataNodeStorageGB")) {
                this.dataNodeStorageGB(model.getDataNodeStorageGB());
            }
            if (model.wasPropertyExplicitlySet("opendashboardNodeCount")) {
                this.opendashboardNodeCount(model.getOpendashboardNodeCount());
            }
            if (model.wasPropertyExplicitlySet("opendashboardNodeHostOcpuCount")) {
                this.opendashboardNodeHostOcpuCount(model.getOpendashboardNodeHostOcpuCount());
            }
            if (model.wasPropertyExplicitlySet("opendashboardNodeHostMemoryGB")) {
                this.opendashboardNodeHostMemoryGB(model.getOpendashboardNodeHostMemoryGB());
            }
            if (model.wasPropertyExplicitlySet("vcnId")) {
                this.vcnId(model.getVcnId());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("vcnCompartmentId")) {
                this.vcnCompartmentId(model.getVcnCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("subnetCompartmentId")) {
                this.subnetCompartmentId(model.getSubnetCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("fqdn")) {
                this.fqdn(model.getFqdn());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomains")) {
                this.availabilityDomains(model.getAvailabilityDomains());
            }
            if (model.wasPropertyExplicitlySet("securityMode")) {
                this.securityMode(model.getSecurityMode());
            }
            if (model.wasPropertyExplicitlySet("securityMasterUserName")) {
                this.securityMasterUserName(model.getSecurityMasterUserName());
            }
            if (model.wasPropertyExplicitlySet("securityMasterUserPasswordHash")) {
                this.securityMasterUserPasswordHash(model.getSecurityMasterUserPasswordHash());
            }
            return this;
        }
    }
}

