/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.opsi.OperationsInsightsAsync;
import com.oracle.bmc.opsi.internal.http.IngestSqlBucketConverter;
import com.oracle.bmc.opsi.internal.http.IngestSqlPlanLinesConverter;
import com.oracle.bmc.opsi.internal.http.IngestSqlTextConverter;
import com.oracle.bmc.opsi.internal.http.ListDatabaseInsightsConverter;
import com.oracle.bmc.opsi.internal.http.ListSqlPlansConverter;
import com.oracle.bmc.opsi.internal.http.ListSqlSearchesConverter;
import com.oracle.bmc.opsi.internal.http.ListSqlTextsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceCapacityTrendConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceForecastTrendConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceStatisticsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceUsageConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceUsageTrendConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceUtilizationInsightConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlInsightsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlPlanInsightsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlResponseTimeDistributionsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlStatisticsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlStatisticsTimeSeriesByPlanConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlStatisticsTimeSeriesConverter;
import com.oracle.bmc.opsi.requests.IngestSqlBucketRequest;
import com.oracle.bmc.opsi.requests.IngestSqlPlanLinesRequest;
import com.oracle.bmc.opsi.requests.IngestSqlTextRequest;
import com.oracle.bmc.opsi.requests.ListDatabaseInsightsRequest;
import com.oracle.bmc.opsi.requests.ListSqlPlansRequest;
import com.oracle.bmc.opsi.requests.ListSqlSearchesRequest;
import com.oracle.bmc.opsi.requests.ListSqlTextsRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceCapacityTrendRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceForecastTrendRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceStatisticsRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceUsageRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceUsageTrendRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceUtilizationInsightRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlInsightsRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlPlanInsightsRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlResponseTimeDistributionsRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlStatisticsRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlStatisticsTimeSeriesByPlanRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlStatisticsTimeSeriesRequest;
import com.oracle.bmc.opsi.responses.IngestSqlBucketResponse;
import com.oracle.bmc.opsi.responses.IngestSqlPlanLinesResponse;
import com.oracle.bmc.opsi.responses.IngestSqlTextResponse;
import com.oracle.bmc.opsi.responses.ListDatabaseInsightsResponse;
import com.oracle.bmc.opsi.responses.ListSqlPlansResponse;
import com.oracle.bmc.opsi.responses.ListSqlSearchesResponse;
import com.oracle.bmc.opsi.responses.ListSqlTextsResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceCapacityTrendResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceForecastTrendResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceStatisticsResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceUsageResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceUsageTrendResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceUtilizationInsightResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlInsightsResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlPlanInsightsResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlResponseTimeDistributionsResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlStatisticsResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlStatisticsTimeSeriesByPlanResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlStatisticsTimeSeriesResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationsInsightsAsyncClient
implements OperationsInsightsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(OperationsInsightsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPERATIONSINSIGHTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://operationsinsights.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public OperationsInsightsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OperationsInsightsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OperationsInsightsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OperationsInsightsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OperationsInsightsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OperationsInsightsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OperationsInsightsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public OperationsInsightsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<IngestSqlBucketResponse> ingestSqlBucket(IngestSqlBucketRequest request, AsyncHandler<IngestSqlBucketRequest, IngestSqlBucketResponse> handler) {
        LOG.trace("Called async ingestSqlBucket");
        IngestSqlBucketRequest interceptedRequest = IngestSqlBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = IngestSqlBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, IngestSqlBucketResponse> transformer = IngestSqlBucketConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<IngestSqlBucketRequest, IngestSqlBucketResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<IngestSqlBucketRequest, IngestSqlBucketResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<IngestSqlPlanLinesResponse> ingestSqlPlanLines(IngestSqlPlanLinesRequest request, AsyncHandler<IngestSqlPlanLinesRequest, IngestSqlPlanLinesResponse> handler) {
        LOG.trace("Called async ingestSqlPlanLines");
        IngestSqlPlanLinesRequest interceptedRequest = IngestSqlPlanLinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = IngestSqlPlanLinesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, IngestSqlPlanLinesResponse> transformer = IngestSqlPlanLinesConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<IngestSqlPlanLinesRequest, IngestSqlPlanLinesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<IngestSqlPlanLinesRequest, IngestSqlPlanLinesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<IngestSqlTextResponse> ingestSqlText(IngestSqlTextRequest request, AsyncHandler<IngestSqlTextRequest, IngestSqlTextResponse> handler) {
        LOG.trace("Called async ingestSqlText");
        IngestSqlTextRequest interceptedRequest = IngestSqlTextConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = IngestSqlTextConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, IngestSqlTextResponse> transformer = IngestSqlTextConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<IngestSqlTextRequest, IngestSqlTextResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<IngestSqlTextRequest, IngestSqlTextResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDatabaseInsightsResponse> listDatabaseInsights(ListDatabaseInsightsRequest request, AsyncHandler<ListDatabaseInsightsRequest, ListDatabaseInsightsResponse> handler) {
        LOG.trace("Called async listDatabaseInsights");
        ListDatabaseInsightsRequest interceptedRequest = ListDatabaseInsightsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDatabaseInsightsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDatabaseInsightsResponse> transformer = ListDatabaseInsightsConverter.fromResponse();
        AsyncHandler<ListDatabaseInsightsRequest, ListDatabaseInsightsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDatabaseInsightsRequest, ListDatabaseInsightsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSqlPlansResponse> listSqlPlans(ListSqlPlansRequest request, AsyncHandler<ListSqlPlansRequest, ListSqlPlansResponse> handler) {
        LOG.trace("Called async listSqlPlans");
        ListSqlPlansRequest interceptedRequest = ListSqlPlansConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSqlPlansConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSqlPlansResponse> transformer = ListSqlPlansConverter.fromResponse();
        AsyncHandler<ListSqlPlansRequest, ListSqlPlansResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSqlPlansRequest, ListSqlPlansResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSqlSearchesResponse> listSqlSearches(ListSqlSearchesRequest request, AsyncHandler<ListSqlSearchesRequest, ListSqlSearchesResponse> handler) {
        LOG.trace("Called async listSqlSearches");
        ListSqlSearchesRequest interceptedRequest = ListSqlSearchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSqlSearchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSqlSearchesResponse> transformer = ListSqlSearchesConverter.fromResponse();
        AsyncHandler<ListSqlSearchesRequest, ListSqlSearchesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSqlSearchesRequest, ListSqlSearchesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSqlTextsResponse> listSqlTexts(ListSqlTextsRequest request, AsyncHandler<ListSqlTextsRequest, ListSqlTextsResponse> handler) {
        LOG.trace("Called async listSqlTexts");
        ListSqlTextsRequest interceptedRequest = ListSqlTextsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSqlTextsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSqlTextsResponse> transformer = ListSqlTextsConverter.fromResponse();
        AsyncHandler<ListSqlTextsRequest, ListSqlTextsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSqlTextsRequest, ListSqlTextsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeDatabaseInsightResourceCapacityTrendResponse> summarizeDatabaseInsightResourceCapacityTrend(SummarizeDatabaseInsightResourceCapacityTrendRequest request, AsyncHandler<SummarizeDatabaseInsightResourceCapacityTrendRequest, SummarizeDatabaseInsightResourceCapacityTrendResponse> handler) {
        LOG.trace("Called async summarizeDatabaseInsightResourceCapacityTrend");
        SummarizeDatabaseInsightResourceCapacityTrendRequest interceptedRequest = SummarizeDatabaseInsightResourceCapacityTrendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceCapacityTrendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceCapacityTrendResponse> transformer = SummarizeDatabaseInsightResourceCapacityTrendConverter.fromResponse();
        AsyncHandler<SummarizeDatabaseInsightResourceCapacityTrendRequest, SummarizeDatabaseInsightResourceCapacityTrendResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeDatabaseInsightResourceCapacityTrendRequest, SummarizeDatabaseInsightResourceCapacityTrendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeDatabaseInsightResourceForecastTrendResponse> summarizeDatabaseInsightResourceForecastTrend(SummarizeDatabaseInsightResourceForecastTrendRequest request, AsyncHandler<SummarizeDatabaseInsightResourceForecastTrendRequest, SummarizeDatabaseInsightResourceForecastTrendResponse> handler) {
        LOG.trace("Called async summarizeDatabaseInsightResourceForecastTrend");
        SummarizeDatabaseInsightResourceForecastTrendRequest interceptedRequest = SummarizeDatabaseInsightResourceForecastTrendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceForecastTrendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceForecastTrendResponse> transformer = SummarizeDatabaseInsightResourceForecastTrendConverter.fromResponse();
        AsyncHandler<SummarizeDatabaseInsightResourceForecastTrendRequest, SummarizeDatabaseInsightResourceForecastTrendResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeDatabaseInsightResourceForecastTrendRequest, SummarizeDatabaseInsightResourceForecastTrendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeDatabaseInsightResourceStatisticsResponse> summarizeDatabaseInsightResourceStatistics(SummarizeDatabaseInsightResourceStatisticsRequest request, AsyncHandler<SummarizeDatabaseInsightResourceStatisticsRequest, SummarizeDatabaseInsightResourceStatisticsResponse> handler) {
        LOG.trace("Called async summarizeDatabaseInsightResourceStatistics");
        SummarizeDatabaseInsightResourceStatisticsRequest interceptedRequest = SummarizeDatabaseInsightResourceStatisticsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceStatisticsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceStatisticsResponse> transformer = SummarizeDatabaseInsightResourceStatisticsConverter.fromResponse();
        AsyncHandler<SummarizeDatabaseInsightResourceStatisticsRequest, SummarizeDatabaseInsightResourceStatisticsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeDatabaseInsightResourceStatisticsRequest, SummarizeDatabaseInsightResourceStatisticsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeDatabaseInsightResourceUsageResponse> summarizeDatabaseInsightResourceUsage(SummarizeDatabaseInsightResourceUsageRequest request, AsyncHandler<SummarizeDatabaseInsightResourceUsageRequest, SummarizeDatabaseInsightResourceUsageResponse> handler) {
        LOG.trace("Called async summarizeDatabaseInsightResourceUsage");
        SummarizeDatabaseInsightResourceUsageRequest interceptedRequest = SummarizeDatabaseInsightResourceUsageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceUsageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceUsageResponse> transformer = SummarizeDatabaseInsightResourceUsageConverter.fromResponse();
        AsyncHandler<SummarizeDatabaseInsightResourceUsageRequest, SummarizeDatabaseInsightResourceUsageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeDatabaseInsightResourceUsageRequest, SummarizeDatabaseInsightResourceUsageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeDatabaseInsightResourceUsageTrendResponse> summarizeDatabaseInsightResourceUsageTrend(SummarizeDatabaseInsightResourceUsageTrendRequest request, AsyncHandler<SummarizeDatabaseInsightResourceUsageTrendRequest, SummarizeDatabaseInsightResourceUsageTrendResponse> handler) {
        LOG.trace("Called async summarizeDatabaseInsightResourceUsageTrend");
        SummarizeDatabaseInsightResourceUsageTrendRequest interceptedRequest = SummarizeDatabaseInsightResourceUsageTrendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceUsageTrendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceUsageTrendResponse> transformer = SummarizeDatabaseInsightResourceUsageTrendConverter.fromResponse();
        AsyncHandler<SummarizeDatabaseInsightResourceUsageTrendRequest, SummarizeDatabaseInsightResourceUsageTrendResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeDatabaseInsightResourceUsageTrendRequest, SummarizeDatabaseInsightResourceUsageTrendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeDatabaseInsightResourceUtilizationInsightResponse> summarizeDatabaseInsightResourceUtilizationInsight(SummarizeDatabaseInsightResourceUtilizationInsightRequest request, AsyncHandler<SummarizeDatabaseInsightResourceUtilizationInsightRequest, SummarizeDatabaseInsightResourceUtilizationInsightResponse> handler) {
        LOG.trace("Called async summarizeDatabaseInsightResourceUtilizationInsight");
        SummarizeDatabaseInsightResourceUtilizationInsightRequest interceptedRequest = SummarizeDatabaseInsightResourceUtilizationInsightConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceUtilizationInsightConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceUtilizationInsightResponse> transformer = SummarizeDatabaseInsightResourceUtilizationInsightConverter.fromResponse();
        AsyncHandler<SummarizeDatabaseInsightResourceUtilizationInsightRequest, SummarizeDatabaseInsightResourceUtilizationInsightResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeDatabaseInsightResourceUtilizationInsightRequest, SummarizeDatabaseInsightResourceUtilizationInsightResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeSqlInsightsResponse> summarizeSqlInsights(SummarizeSqlInsightsRequest request, AsyncHandler<SummarizeSqlInsightsRequest, SummarizeSqlInsightsResponse> handler) {
        LOG.trace("Called async summarizeSqlInsights");
        SummarizeSqlInsightsRequest interceptedRequest = SummarizeSqlInsightsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlInsightsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlInsightsResponse> transformer = SummarizeSqlInsightsConverter.fromResponse();
        AsyncHandler<SummarizeSqlInsightsRequest, SummarizeSqlInsightsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeSqlInsightsRequest, SummarizeSqlInsightsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeSqlPlanInsightsResponse> summarizeSqlPlanInsights(SummarizeSqlPlanInsightsRequest request, AsyncHandler<SummarizeSqlPlanInsightsRequest, SummarizeSqlPlanInsightsResponse> handler) {
        LOG.trace("Called async summarizeSqlPlanInsights");
        SummarizeSqlPlanInsightsRequest interceptedRequest = SummarizeSqlPlanInsightsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlPlanInsightsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlPlanInsightsResponse> transformer = SummarizeSqlPlanInsightsConverter.fromResponse();
        AsyncHandler<SummarizeSqlPlanInsightsRequest, SummarizeSqlPlanInsightsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeSqlPlanInsightsRequest, SummarizeSqlPlanInsightsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeSqlResponseTimeDistributionsResponse> summarizeSqlResponseTimeDistributions(SummarizeSqlResponseTimeDistributionsRequest request, AsyncHandler<SummarizeSqlResponseTimeDistributionsRequest, SummarizeSqlResponseTimeDistributionsResponse> handler) {
        LOG.trace("Called async summarizeSqlResponseTimeDistributions");
        SummarizeSqlResponseTimeDistributionsRequest interceptedRequest = SummarizeSqlResponseTimeDistributionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlResponseTimeDistributionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlResponseTimeDistributionsResponse> transformer = SummarizeSqlResponseTimeDistributionsConverter.fromResponse();
        AsyncHandler<SummarizeSqlResponseTimeDistributionsRequest, SummarizeSqlResponseTimeDistributionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeSqlResponseTimeDistributionsRequest, SummarizeSqlResponseTimeDistributionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeSqlStatisticsResponse> summarizeSqlStatistics(SummarizeSqlStatisticsRequest request, AsyncHandler<SummarizeSqlStatisticsRequest, SummarizeSqlStatisticsResponse> handler) {
        LOG.trace("Called async summarizeSqlStatistics");
        SummarizeSqlStatisticsRequest interceptedRequest = SummarizeSqlStatisticsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlStatisticsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlStatisticsResponse> transformer = SummarizeSqlStatisticsConverter.fromResponse();
        AsyncHandler<SummarizeSqlStatisticsRequest, SummarizeSqlStatisticsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeSqlStatisticsRequest, SummarizeSqlStatisticsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeSqlStatisticsTimeSeriesResponse> summarizeSqlStatisticsTimeSeries(SummarizeSqlStatisticsTimeSeriesRequest request, AsyncHandler<SummarizeSqlStatisticsTimeSeriesRequest, SummarizeSqlStatisticsTimeSeriesResponse> handler) {
        LOG.trace("Called async summarizeSqlStatisticsTimeSeries");
        SummarizeSqlStatisticsTimeSeriesRequest interceptedRequest = SummarizeSqlStatisticsTimeSeriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlStatisticsTimeSeriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlStatisticsTimeSeriesResponse> transformer = SummarizeSqlStatisticsTimeSeriesConverter.fromResponse();
        AsyncHandler<SummarizeSqlStatisticsTimeSeriesRequest, SummarizeSqlStatisticsTimeSeriesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeSqlStatisticsTimeSeriesRequest, SummarizeSqlStatisticsTimeSeriesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<SummarizeSqlStatisticsTimeSeriesByPlanResponse> summarizeSqlStatisticsTimeSeriesByPlan(SummarizeSqlStatisticsTimeSeriesByPlanRequest request, AsyncHandler<SummarizeSqlStatisticsTimeSeriesByPlanRequest, SummarizeSqlStatisticsTimeSeriesByPlanResponse> handler) {
        LOG.trace("Called async summarizeSqlStatisticsTimeSeriesByPlan");
        SummarizeSqlStatisticsTimeSeriesByPlanRequest interceptedRequest = SummarizeSqlStatisticsTimeSeriesByPlanConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlStatisticsTimeSeriesByPlanConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlStatisticsTimeSeriesByPlanResponse> transformer = SummarizeSqlStatisticsTimeSeriesByPlanConverter.fromResponse();
        AsyncHandler<SummarizeSqlStatisticsTimeSeriesByPlanRequest, SummarizeSqlStatisticsTimeSeriesByPlanResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<SummarizeSqlStatisticsTimeSeriesByPlanRequest, SummarizeSqlStatisticsTimeSeriesByPlanResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OperationsInsightsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OperationsInsightsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new OperationsInsightsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

