/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.opsi.OperationsInsights;
import com.oracle.bmc.opsi.OperationsInsightsPaginators;
import com.oracle.bmc.opsi.internal.http.IngestSqlBucketConverter;
import com.oracle.bmc.opsi.internal.http.IngestSqlPlanLinesConverter;
import com.oracle.bmc.opsi.internal.http.IngestSqlTextConverter;
import com.oracle.bmc.opsi.internal.http.ListDatabaseInsightsConverter;
import com.oracle.bmc.opsi.internal.http.ListSqlPlansConverter;
import com.oracle.bmc.opsi.internal.http.ListSqlSearchesConverter;
import com.oracle.bmc.opsi.internal.http.ListSqlTextsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceCapacityTrendConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceForecastTrendConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceStatisticsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceUsageConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceUsageTrendConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeDatabaseInsightResourceUtilizationInsightConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlInsightsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlPlanInsightsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlResponseTimeDistributionsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlStatisticsConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlStatisticsTimeSeriesByPlanConverter;
import com.oracle.bmc.opsi.internal.http.SummarizeSqlStatisticsTimeSeriesConverter;
import com.oracle.bmc.opsi.requests.IngestSqlBucketRequest;
import com.oracle.bmc.opsi.requests.IngestSqlPlanLinesRequest;
import com.oracle.bmc.opsi.requests.IngestSqlTextRequest;
import com.oracle.bmc.opsi.requests.ListDatabaseInsightsRequest;
import com.oracle.bmc.opsi.requests.ListSqlPlansRequest;
import com.oracle.bmc.opsi.requests.ListSqlSearchesRequest;
import com.oracle.bmc.opsi.requests.ListSqlTextsRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceCapacityTrendRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceForecastTrendRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceStatisticsRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceUsageRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceUsageTrendRequest;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceUtilizationInsightRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlInsightsRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlPlanInsightsRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlResponseTimeDistributionsRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlStatisticsRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlStatisticsTimeSeriesByPlanRequest;
import com.oracle.bmc.opsi.requests.SummarizeSqlStatisticsTimeSeriesRequest;
import com.oracle.bmc.opsi.responses.IngestSqlBucketResponse;
import com.oracle.bmc.opsi.responses.IngestSqlPlanLinesResponse;
import com.oracle.bmc.opsi.responses.IngestSqlTextResponse;
import com.oracle.bmc.opsi.responses.ListDatabaseInsightsResponse;
import com.oracle.bmc.opsi.responses.ListSqlPlansResponse;
import com.oracle.bmc.opsi.responses.ListSqlSearchesResponse;
import com.oracle.bmc.opsi.responses.ListSqlTextsResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceCapacityTrendResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceForecastTrendResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceStatisticsResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceUsageResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceUsageTrendResponse;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceUtilizationInsightResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlInsightsResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlPlanInsightsResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlResponseTimeDistributionsResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlStatisticsResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlStatisticsTimeSeriesByPlanResponse;
import com.oracle.bmc.opsi.responses.SummarizeSqlStatisticsTimeSeriesResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationsInsightsClient
implements OperationsInsights {
    private static final Logger LOG = LoggerFactory.getLogger(OperationsInsightsClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OPERATIONSINSIGHTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://operationsinsights.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final OperationsInsightsPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public OperationsInsightsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public OperationsInsightsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public OperationsInsightsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public OperationsInsightsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public OperationsInsightsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public OperationsInsightsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public OperationsInsightsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    protected OperationsInsightsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        this.paginators = new OperationsInsightsPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public IngestSqlBucketResponse ingestSqlBucket(IngestSqlBucketRequest request) {
        LOG.trace("Called ingestSqlBucket");
        IngestSqlBucketRequest interceptedRequest = IngestSqlBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = IngestSqlBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, IngestSqlBucketResponse> transformer = IngestSqlBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (IngestSqlBucketResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (IngestSqlBucketResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getIngestSqlBucketDetails(), (BmcRequest)retriedRequest);
                return (IngestSqlBucketResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public IngestSqlPlanLinesResponse ingestSqlPlanLines(IngestSqlPlanLinesRequest request) {
        LOG.trace("Called ingestSqlPlanLines");
        IngestSqlPlanLinesRequest interceptedRequest = IngestSqlPlanLinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = IngestSqlPlanLinesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, IngestSqlPlanLinesResponse> transformer = IngestSqlPlanLinesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (IngestSqlPlanLinesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (IngestSqlPlanLinesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getIngestSqlPlanLinesDetails(), (BmcRequest)retriedRequest);
                return (IngestSqlPlanLinesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public IngestSqlTextResponse ingestSqlText(IngestSqlTextRequest request) {
        LOG.trace("Called ingestSqlText");
        IngestSqlTextRequest interceptedRequest = IngestSqlTextConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = IngestSqlTextConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, IngestSqlTextResponse> transformer = IngestSqlTextConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (IngestSqlTextResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (IngestSqlTextResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getIngestSqlTextDetails(), (BmcRequest)retriedRequest);
                return (IngestSqlTextResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDatabaseInsightsResponse listDatabaseInsights(ListDatabaseInsightsRequest request) {
        LOG.trace("Called listDatabaseInsights");
        ListDatabaseInsightsRequest interceptedRequest = ListDatabaseInsightsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDatabaseInsightsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDatabaseInsightsResponse> transformer = ListDatabaseInsightsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDatabaseInsightsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDatabaseInsightsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDatabaseInsightsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSqlPlansResponse listSqlPlans(ListSqlPlansRequest request) {
        LOG.trace("Called listSqlPlans");
        ListSqlPlansRequest interceptedRequest = ListSqlPlansConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSqlPlansConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSqlPlansResponse> transformer = ListSqlPlansConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSqlPlansResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSqlPlansResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSqlPlansResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSqlSearchesResponse listSqlSearches(ListSqlSearchesRequest request) {
        LOG.trace("Called listSqlSearches");
        ListSqlSearchesRequest interceptedRequest = ListSqlSearchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSqlSearchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSqlSearchesResponse> transformer = ListSqlSearchesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSqlSearchesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSqlSearchesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSqlSearchesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSqlTextsResponse listSqlTexts(ListSqlTextsRequest request) {
        LOG.trace("Called listSqlTexts");
        ListSqlTextsRequest interceptedRequest = ListSqlTextsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSqlTextsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSqlTextsResponse> transformer = ListSqlTextsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSqlTextsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSqlTextsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSqlTextsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeDatabaseInsightResourceCapacityTrendResponse summarizeDatabaseInsightResourceCapacityTrend(SummarizeDatabaseInsightResourceCapacityTrendRequest request) {
        LOG.trace("Called summarizeDatabaseInsightResourceCapacityTrend");
        SummarizeDatabaseInsightResourceCapacityTrendRequest interceptedRequest = SummarizeDatabaseInsightResourceCapacityTrendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceCapacityTrendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceCapacityTrendResponse> transformer = SummarizeDatabaseInsightResourceCapacityTrendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeDatabaseInsightResourceCapacityTrendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeDatabaseInsightResourceCapacityTrendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeDatabaseInsightResourceCapacityTrendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeDatabaseInsightResourceForecastTrendResponse summarizeDatabaseInsightResourceForecastTrend(SummarizeDatabaseInsightResourceForecastTrendRequest request) {
        LOG.trace("Called summarizeDatabaseInsightResourceForecastTrend");
        SummarizeDatabaseInsightResourceForecastTrendRequest interceptedRequest = SummarizeDatabaseInsightResourceForecastTrendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceForecastTrendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceForecastTrendResponse> transformer = SummarizeDatabaseInsightResourceForecastTrendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeDatabaseInsightResourceForecastTrendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeDatabaseInsightResourceForecastTrendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeDatabaseInsightResourceForecastTrendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeDatabaseInsightResourceStatisticsResponse summarizeDatabaseInsightResourceStatistics(SummarizeDatabaseInsightResourceStatisticsRequest request) {
        LOG.trace("Called summarizeDatabaseInsightResourceStatistics");
        SummarizeDatabaseInsightResourceStatisticsRequest interceptedRequest = SummarizeDatabaseInsightResourceStatisticsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceStatisticsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceStatisticsResponse> transformer = SummarizeDatabaseInsightResourceStatisticsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeDatabaseInsightResourceStatisticsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeDatabaseInsightResourceStatisticsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeDatabaseInsightResourceStatisticsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeDatabaseInsightResourceUsageResponse summarizeDatabaseInsightResourceUsage(SummarizeDatabaseInsightResourceUsageRequest request) {
        LOG.trace("Called summarizeDatabaseInsightResourceUsage");
        SummarizeDatabaseInsightResourceUsageRequest interceptedRequest = SummarizeDatabaseInsightResourceUsageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceUsageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceUsageResponse> transformer = SummarizeDatabaseInsightResourceUsageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeDatabaseInsightResourceUsageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeDatabaseInsightResourceUsageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeDatabaseInsightResourceUsageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeDatabaseInsightResourceUsageTrendResponse summarizeDatabaseInsightResourceUsageTrend(SummarizeDatabaseInsightResourceUsageTrendRequest request) {
        LOG.trace("Called summarizeDatabaseInsightResourceUsageTrend");
        SummarizeDatabaseInsightResourceUsageTrendRequest interceptedRequest = SummarizeDatabaseInsightResourceUsageTrendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceUsageTrendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceUsageTrendResponse> transformer = SummarizeDatabaseInsightResourceUsageTrendConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeDatabaseInsightResourceUsageTrendResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeDatabaseInsightResourceUsageTrendResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeDatabaseInsightResourceUsageTrendResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeDatabaseInsightResourceUtilizationInsightResponse summarizeDatabaseInsightResourceUtilizationInsight(SummarizeDatabaseInsightResourceUtilizationInsightRequest request) {
        LOG.trace("Called summarizeDatabaseInsightResourceUtilizationInsight");
        SummarizeDatabaseInsightResourceUtilizationInsightRequest interceptedRequest = SummarizeDatabaseInsightResourceUtilizationInsightConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeDatabaseInsightResourceUtilizationInsightConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeDatabaseInsightResourceUtilizationInsightResponse> transformer = SummarizeDatabaseInsightResourceUtilizationInsightConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeDatabaseInsightResourceUtilizationInsightResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeDatabaseInsightResourceUtilizationInsightResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeDatabaseInsightResourceUtilizationInsightResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeSqlInsightsResponse summarizeSqlInsights(SummarizeSqlInsightsRequest request) {
        LOG.trace("Called summarizeSqlInsights");
        SummarizeSqlInsightsRequest interceptedRequest = SummarizeSqlInsightsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlInsightsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlInsightsResponse> transformer = SummarizeSqlInsightsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeSqlInsightsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeSqlInsightsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeSqlInsightsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeSqlPlanInsightsResponse summarizeSqlPlanInsights(SummarizeSqlPlanInsightsRequest request) {
        LOG.trace("Called summarizeSqlPlanInsights");
        SummarizeSqlPlanInsightsRequest interceptedRequest = SummarizeSqlPlanInsightsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlPlanInsightsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlPlanInsightsResponse> transformer = SummarizeSqlPlanInsightsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeSqlPlanInsightsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeSqlPlanInsightsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeSqlPlanInsightsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeSqlResponseTimeDistributionsResponse summarizeSqlResponseTimeDistributions(SummarizeSqlResponseTimeDistributionsRequest request) {
        LOG.trace("Called summarizeSqlResponseTimeDistributions");
        SummarizeSqlResponseTimeDistributionsRequest interceptedRequest = SummarizeSqlResponseTimeDistributionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlResponseTimeDistributionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlResponseTimeDistributionsResponse> transformer = SummarizeSqlResponseTimeDistributionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeSqlResponseTimeDistributionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeSqlResponseTimeDistributionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeSqlResponseTimeDistributionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeSqlStatisticsResponse summarizeSqlStatistics(SummarizeSqlStatisticsRequest request) {
        LOG.trace("Called summarizeSqlStatistics");
        SummarizeSqlStatisticsRequest interceptedRequest = SummarizeSqlStatisticsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlStatisticsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlStatisticsResponse> transformer = SummarizeSqlStatisticsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeSqlStatisticsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeSqlStatisticsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeSqlStatisticsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeSqlStatisticsTimeSeriesResponse summarizeSqlStatisticsTimeSeries(SummarizeSqlStatisticsTimeSeriesRequest request) {
        LOG.trace("Called summarizeSqlStatisticsTimeSeries");
        SummarizeSqlStatisticsTimeSeriesRequest interceptedRequest = SummarizeSqlStatisticsTimeSeriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlStatisticsTimeSeriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlStatisticsTimeSeriesResponse> transformer = SummarizeSqlStatisticsTimeSeriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeSqlStatisticsTimeSeriesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeSqlStatisticsTimeSeriesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeSqlStatisticsTimeSeriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeSqlStatisticsTimeSeriesByPlanResponse summarizeSqlStatisticsTimeSeriesByPlan(SummarizeSqlStatisticsTimeSeriesByPlanRequest request) {
        LOG.trace("Called summarizeSqlStatisticsTimeSeriesByPlan");
        SummarizeSqlStatisticsTimeSeriesByPlanRequest interceptedRequest = SummarizeSqlStatisticsTimeSeriesByPlanConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeSqlStatisticsTimeSeriesByPlanConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeSqlStatisticsTimeSeriesByPlanResponse> transformer = SummarizeSqlStatisticsTimeSeriesByPlanConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (SummarizeSqlStatisticsTimeSeriesByPlanResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (SummarizeSqlStatisticsTimeSeriesByPlanResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (SummarizeSqlStatisticsTimeSeriesByPlanResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public OperationsInsightsPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OperationsInsightsClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OperationsInsightsClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new OperationsInsightsClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

