/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.opsi.OperationsInsights;
import com.oracle.bmc.opsi.model.DatabaseInsightSummary;
import com.oracle.bmc.opsi.model.SqlPlanSummary;
import com.oracle.bmc.opsi.model.SqlSearchSummary;
import com.oracle.bmc.opsi.model.SqlTextSummary;
import com.oracle.bmc.opsi.requests.ListDatabaseInsightsRequest;
import com.oracle.bmc.opsi.requests.ListSqlPlansRequest;
import com.oracle.bmc.opsi.requests.ListSqlSearchesRequest;
import com.oracle.bmc.opsi.requests.ListSqlTextsRequest;
import com.oracle.bmc.opsi.responses.ListDatabaseInsightsResponse;
import com.oracle.bmc.opsi.responses.ListSqlPlansResponse;
import com.oracle.bmc.opsi.responses.ListSqlSearchesResponse;
import com.oracle.bmc.opsi.responses.ListSqlTextsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class OperationsInsightsPaginators {
    private final OperationsInsights client;

    public Iterable<ListDatabaseInsightsResponse> listDatabaseInsightsResponseIterator(final ListDatabaseInsightsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDatabaseInsightsRequest.Builder>(){

            public ListDatabaseInsightsRequest.Builder get() {
                return ListDatabaseInsightsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseInsightsResponse, String>(){

            public String apply(ListDatabaseInsightsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseInsightsRequest.Builder>, ListDatabaseInsightsRequest>(){

            public ListDatabaseInsightsRequest apply(RequestBuilderAndToken<ListDatabaseInsightsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDatabaseInsightsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseInsightsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDatabaseInsightsRequest, ListDatabaseInsightsResponse>(){

            public ListDatabaseInsightsResponse apply(ListDatabaseInsightsRequest request) {
                return OperationsInsightsPaginators.this.client.listDatabaseInsights(request);
            }
        });
    }

    public Iterable<DatabaseInsightSummary> listDatabaseInsightsRecordIterator(final ListDatabaseInsightsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDatabaseInsightsRequest.Builder>(){

            public ListDatabaseInsightsRequest.Builder get() {
                return ListDatabaseInsightsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseInsightsResponse, String>(){

            public String apply(ListDatabaseInsightsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseInsightsRequest.Builder>, ListDatabaseInsightsRequest>(){

            public ListDatabaseInsightsRequest apply(RequestBuilderAndToken<ListDatabaseInsightsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDatabaseInsightsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseInsightsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDatabaseInsightsRequest, ListDatabaseInsightsResponse>(){

            public ListDatabaseInsightsResponse apply(ListDatabaseInsightsRequest request) {
                return OperationsInsightsPaginators.this.client.listDatabaseInsights(request);
            }
        }, (Function)new Function<ListDatabaseInsightsResponse, List<DatabaseInsightSummary>>(){

            public List<DatabaseInsightSummary> apply(ListDatabaseInsightsResponse response) {
                return response.getDatabaseInsightsCollection().getItems();
            }
        });
    }

    public Iterable<ListSqlPlansResponse> listSqlPlansResponseIterator(final ListSqlPlansRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSqlPlansRequest.Builder>(){

            public ListSqlPlansRequest.Builder get() {
                return ListSqlPlansRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSqlPlansResponse, String>(){

            public String apply(ListSqlPlansResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSqlPlansRequest.Builder>, ListSqlPlansRequest>(){

            public ListSqlPlansRequest apply(RequestBuilderAndToken<ListSqlPlansRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSqlPlansRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSqlPlansRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSqlPlansRequest, ListSqlPlansResponse>(){

            public ListSqlPlansResponse apply(ListSqlPlansRequest request) {
                return OperationsInsightsPaginators.this.client.listSqlPlans(request);
            }
        });
    }

    public Iterable<SqlPlanSummary> listSqlPlansRecordIterator(final ListSqlPlansRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSqlPlansRequest.Builder>(){

            public ListSqlPlansRequest.Builder get() {
                return ListSqlPlansRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSqlPlansResponse, String>(){

            public String apply(ListSqlPlansResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSqlPlansRequest.Builder>, ListSqlPlansRequest>(){

            public ListSqlPlansRequest apply(RequestBuilderAndToken<ListSqlPlansRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSqlPlansRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSqlPlansRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSqlPlansRequest, ListSqlPlansResponse>(){

            public ListSqlPlansResponse apply(ListSqlPlansRequest request) {
                return OperationsInsightsPaginators.this.client.listSqlPlans(request);
            }
        }, (Function)new Function<ListSqlPlansResponse, List<SqlPlanSummary>>(){

            public List<SqlPlanSummary> apply(ListSqlPlansResponse response) {
                return response.getSqlPlanCollection().getItems();
            }
        });
    }

    public Iterable<ListSqlSearchesResponse> listSqlSearchesResponseIterator(final ListSqlSearchesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSqlSearchesRequest.Builder>(){

            public ListSqlSearchesRequest.Builder get() {
                return ListSqlSearchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSqlSearchesResponse, String>(){

            public String apply(ListSqlSearchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSqlSearchesRequest.Builder>, ListSqlSearchesRequest>(){

            public ListSqlSearchesRequest apply(RequestBuilderAndToken<ListSqlSearchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSqlSearchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSqlSearchesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSqlSearchesRequest, ListSqlSearchesResponse>(){

            public ListSqlSearchesResponse apply(ListSqlSearchesRequest request) {
                return OperationsInsightsPaginators.this.client.listSqlSearches(request);
            }
        });
    }

    public Iterable<SqlSearchSummary> listSqlSearchesRecordIterator(final ListSqlSearchesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSqlSearchesRequest.Builder>(){

            public ListSqlSearchesRequest.Builder get() {
                return ListSqlSearchesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSqlSearchesResponse, String>(){

            public String apply(ListSqlSearchesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSqlSearchesRequest.Builder>, ListSqlSearchesRequest>(){

            public ListSqlSearchesRequest apply(RequestBuilderAndToken<ListSqlSearchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSqlSearchesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSqlSearchesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSqlSearchesRequest, ListSqlSearchesResponse>(){

            public ListSqlSearchesResponse apply(ListSqlSearchesRequest request) {
                return OperationsInsightsPaginators.this.client.listSqlSearches(request);
            }
        }, (Function)new Function<ListSqlSearchesResponse, List<SqlSearchSummary>>(){

            public List<SqlSearchSummary> apply(ListSqlSearchesResponse response) {
                return response.getSqlSearchCollection().getItems();
            }
        });
    }

    public Iterable<ListSqlTextsResponse> listSqlTextsResponseIterator(final ListSqlTextsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSqlTextsRequest.Builder>(){

            public ListSqlTextsRequest.Builder get() {
                return ListSqlTextsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSqlTextsResponse, String>(){

            public String apply(ListSqlTextsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSqlTextsRequest.Builder>, ListSqlTextsRequest>(){

            public ListSqlTextsRequest apply(RequestBuilderAndToken<ListSqlTextsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSqlTextsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSqlTextsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSqlTextsRequest, ListSqlTextsResponse>(){

            public ListSqlTextsResponse apply(ListSqlTextsRequest request) {
                return OperationsInsightsPaginators.this.client.listSqlTexts(request);
            }
        });
    }

    public Iterable<SqlTextSummary> listSqlTextsRecordIterator(final ListSqlTextsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSqlTextsRequest.Builder>(){

            public ListSqlTextsRequest.Builder get() {
                return ListSqlTextsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSqlTextsResponse, String>(){

            public String apply(ListSqlTextsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSqlTextsRequest.Builder>, ListSqlTextsRequest>(){

            public ListSqlTextsRequest apply(RequestBuilderAndToken<ListSqlTextsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSqlTextsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSqlTextsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSqlTextsRequest, ListSqlTextsResponse>(){

            public ListSqlTextsResponse apply(ListSqlTextsRequest request) {
                return OperationsInsightsPaginators.this.client.listSqlTexts(request);
            }
        }, (Function)new Function<ListSqlTextsResponse, List<SqlTextSummary>>(){

            public List<SqlTextSummary> apply(ListSqlTextsResponse response) {
                return response.getSqlTextCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public OperationsInsightsPaginators(OperationsInsights client) {
        this.client = client;
    }
}

