/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.opsi.model.DatabaseInsightsCollection;
import com.oracle.bmc.opsi.requests.ListDatabaseInsightsRequest;
import com.oracle.bmc.opsi.responses.ListDatabaseInsightsResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDatabaseInsightsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListDatabaseInsightsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListDatabaseInsightsRequest interceptRequest(ListDatabaseInsightsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListDatabaseInsightsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("databaseInsights");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getDatabaseType() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"databaseType", request.getDatabaseType(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getDatabaseId() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"databaseId", request.getDatabaseId(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getFields() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"fields", request.getFields(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListDatabaseInsightsResponse> fromResponse() {
        Function<Response, ListDatabaseInsightsResponse> transformer = new Function<Response, ListDatabaseInsightsResponse>(){

            public ListDatabaseInsightsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                Optional opcTotalItemsHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.opsi.responses.ListDatabaseInsightsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DatabaseInsightsCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListDatabaseInsightsResponse.Builder builder = ListDatabaseInsightsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.databaseInsightsCollection((DatabaseInsightsCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-total-items")).isPresent()) {
                    builder.opcTotalItems((Integer)HeaderUtils.toValue((String)"opc-total-items", (String)((String)((List)opcTotalItemsHeader.get()).get(0)), Integer.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListDatabaseInsightsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

