/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.opsi.model.SqlPlanCollection;
import com.oracle.bmc.opsi.requests.ListSqlPlansRequest;
import com.oracle.bmc.opsi.responses.ListSqlPlansResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSqlPlansConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListSqlPlansConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListSqlPlansRequest interceptRequest(ListSqlPlansRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListSqlPlansRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getDatabaseId(), (String)"databaseId is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getSqlIdentifier(), (String)"sqlIdentifier is required", (Object[])new Object[0]);
        Validate.notNull(request.getPlanHash(), (String)"planHash is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("databaseInsights").path("sqlPlans");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        target = target.queryParam("databaseId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDatabaseId())});
        target = target.queryParam("sqlIdentifier", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSqlIdentifier())});
        target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"planHash", request.getPlanHash(), (CollectionFormatType)CollectionFormatType.Multi);
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListSqlPlansResponse> fromResponse() {
        Function<Response, ListSqlPlansResponse> transformer = new Function<Response, ListSqlPlansResponse>(){

            public ListSqlPlansResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.opsi.responses.ListSqlPlansResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(SqlPlanCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListSqlPlansResponse.Builder builder = ListSqlPlansResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.sqlPlanCollection((SqlPlanCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListSqlPlansResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

