/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.opsi.model.SummarizeDatabaseInsightResourceStatisticsAggregationCollection;
import com.oracle.bmc.opsi.requests.SummarizeDatabaseInsightResourceStatisticsRequest;
import com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceStatisticsResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummarizeDatabaseInsightResourceStatisticsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SummarizeDatabaseInsightResourceStatisticsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static SummarizeDatabaseInsightResourceStatisticsRequest interceptRequest(SummarizeDatabaseInsightResourceStatisticsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, SummarizeDatabaseInsightResourceStatisticsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getResourceMetric(), (String)"resourceMetric is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("databaseInsights").path("resourceStatistics");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        target = target.queryParam("resourceMetric", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getResourceMetric())});
        if (request.getAnalysisTimeInterval() != null) {
            target = target.queryParam("analysisTimeInterval", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAnalysisTimeInterval())});
        }
        if (request.getTimeIntervalStart() != null) {
            target = target.queryParam("timeIntervalStart", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeIntervalStart())});
        }
        if (request.getTimeIntervalEnd() != null) {
            target = target.queryParam("timeIntervalEnd", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeIntervalEnd())});
        }
        if (request.getDatabaseType() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"databaseType", request.getDatabaseType(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getDatabaseId() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"databaseId", request.getDatabaseId(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getPercentile() != null) {
            target = target.queryParam("percentile", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPercentile())});
        }
        if (request.getInsightBy() != null) {
            target = target.queryParam("insightBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getInsightBy())});
        }
        if (request.getForecastDays() != null) {
            target = target.queryParam("forecastDays", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getForecastDays())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, SummarizeDatabaseInsightResourceStatisticsResponse> fromResponse() {
        Function<Response, SummarizeDatabaseInsightResourceStatisticsResponse> transformer = new Function<Response, SummarizeDatabaseInsightResourceStatisticsResponse>(){

            public SummarizeDatabaseInsightResourceStatisticsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.opsi.responses.SummarizeDatabaseInsightResourceStatisticsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(SummarizeDatabaseInsightResourceStatisticsAggregationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                SummarizeDatabaseInsightResourceStatisticsResponse.Builder builder = SummarizeDatabaseInsightResourceStatisticsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.summarizeDatabaseInsightResourceStatisticsAggregationCollection((SummarizeDatabaseInsightResourceStatisticsAggregationCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                SummarizeDatabaseInsightResourceStatisticsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

