/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.opsi.model.SqlInsightAggregationCollection;
import com.oracle.bmc.opsi.requests.SummarizeSqlInsightsRequest;
import com.oracle.bmc.opsi.responses.SummarizeSqlInsightsResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummarizeSqlInsightsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SummarizeSqlInsightsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static SummarizeSqlInsightsRequest interceptRequest(SummarizeSqlInsightsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, SummarizeSqlInsightsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("databaseInsights").path("sqlInsights");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getDatabaseType() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"databaseType", request.getDatabaseType(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getDatabaseId() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"databaseId", request.getDatabaseId(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getDatabaseTimePctGreaterThan() != null) {
            target = target.queryParam("databaseTimePctGreaterThan", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDatabaseTimePctGreaterThan())});
        }
        if (request.getAnalysisTimeInterval() != null) {
            target = target.queryParam("analysisTimeInterval", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAnalysisTimeInterval())});
        }
        if (request.getTimeIntervalStart() != null) {
            target = target.queryParam("timeIntervalStart", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeIntervalStart())});
        }
        if (request.getTimeIntervalEnd() != null) {
            target = target.queryParam("timeIntervalEnd", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeIntervalEnd())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, SummarizeSqlInsightsResponse> fromResponse() {
        Function<Response, SummarizeSqlInsightsResponse> transformer = new Function<Response, SummarizeSqlInsightsResponse>(){

            public SummarizeSqlInsightsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.opsi.responses.SummarizeSqlInsightsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(SqlInsightAggregationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                SummarizeSqlInsightsResponse.Builder builder = SummarizeSqlInsightsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.sqlInsightAggregationCollection((SqlInsightAggregationCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                SummarizeSqlInsightsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

