/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.opsi.model.SqlPlanInsightAggregationCollection;
import com.oracle.bmc.opsi.requests.SummarizeSqlPlanInsightsRequest;
import com.oracle.bmc.opsi.responses.SummarizeSqlPlanInsightsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummarizeSqlPlanInsightsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SummarizeSqlPlanInsightsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static SummarizeSqlPlanInsightsRequest interceptRequest(SummarizeSqlPlanInsightsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, SummarizeSqlPlanInsightsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getDatabaseId(), (String)"databaseId is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getSqlIdentifier(), (String)"sqlIdentifier is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("databaseInsights").path("sqlPlanInsights");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        target = target.queryParam("databaseId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDatabaseId())});
        target = target.queryParam("sqlIdentifier", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSqlIdentifier())});
        if (request.getAnalysisTimeInterval() != null) {
            target = target.queryParam("analysisTimeInterval", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAnalysisTimeInterval())});
        }
        if (request.getTimeIntervalStart() != null) {
            target = target.queryParam("timeIntervalStart", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeIntervalStart())});
        }
        if (request.getTimeIntervalEnd() != null) {
            target = target.queryParam("timeIntervalEnd", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeIntervalEnd())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, SummarizeSqlPlanInsightsResponse> fromResponse() {
        Function<Response, SummarizeSqlPlanInsightsResponse> transformer = new Function<Response, SummarizeSqlPlanInsightsResponse>(){

            public SummarizeSqlPlanInsightsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.opsi.responses.SummarizeSqlPlanInsightsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(SqlPlanInsightAggregationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                SummarizeSqlPlanInsightsResponse.Builder builder = SummarizeSqlPlanInsightsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.sqlPlanInsightAggregationCollection((SqlPlanInsightAggregationCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                SummarizeSqlPlanInsightsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

