/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.opsi.model.SqlStatisticsTimeSeriesAggregationCollection;
import com.oracle.bmc.opsi.requests.SummarizeSqlStatisticsTimeSeriesRequest;
import com.oracle.bmc.opsi.responses.SummarizeSqlStatisticsTimeSeriesResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummarizeSqlStatisticsTimeSeriesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SummarizeSqlStatisticsTimeSeriesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static SummarizeSqlStatisticsTimeSeriesRequest interceptRequest(SummarizeSqlStatisticsTimeSeriesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, SummarizeSqlStatisticsTimeSeriesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getSqlIdentifier(), (String)"sqlIdentifier is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200630").path("databaseInsights").path("sqlStatisticsTimeSeries");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getDatabaseId() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"databaseId", request.getDatabaseId(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        target = target.queryParam("sqlIdentifier", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSqlIdentifier())});
        if (request.getAnalysisTimeInterval() != null) {
            target = target.queryParam("analysisTimeInterval", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getAnalysisTimeInterval())});
        }
        if (request.getTimeIntervalStart() != null) {
            target = target.queryParam("timeIntervalStart", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeIntervalStart())});
        }
        if (request.getTimeIntervalEnd() != null) {
            target = target.queryParam("timeIntervalEnd", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeIntervalEnd())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, SummarizeSqlStatisticsTimeSeriesResponse> fromResponse() {
        Function<Response, SummarizeSqlStatisticsTimeSeriesResponse> transformer = new Function<Response, SummarizeSqlStatisticsTimeSeriesResponse>(){

            public SummarizeSqlStatisticsTimeSeriesResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.opsi.responses.SummarizeSqlStatisticsTimeSeriesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(SqlStatisticsTimeSeriesAggregationCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                SummarizeSqlStatisticsTimeSeriesResponse.Builder builder = SummarizeSqlStatisticsTimeSeriesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.sqlStatisticsTimeSeriesAggregationCollection((SqlStatisticsTimeSeriesAggregationCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                SummarizeSqlStatisticsTimeSeriesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

