/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDatabaseInsightsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<DatabaseType> databaseType;
    private List<String> databaseId;
    private List<Fields> fields;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "databaseType", "databaseId", "fields", "limit", "page", "sortOrder", "sortBy", "opcRequestId"})
    ListDatabaseInsightsRequest(String compartmentId, List<DatabaseType> databaseType, List<String> databaseId, List<Fields> fields, Integer limit, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.databaseType = databaseType;
        this.databaseId = databaseId;
        this.fields = fields;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<DatabaseType> getDatabaseType() {
        return this.databaseType;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDatabaseInsightsRequest, Void> {
        private String compartmentId;
        private List<DatabaseType> databaseType;
        private List<String> databaseId;
        private List<Fields> fields;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDatabaseInsightsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.databaseType(o.getDatabaseType());
            this.databaseId(o.getDatabaseId());
            this.fields(o.getFields());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDatabaseInsightsRequest build() {
            ListDatabaseInsightsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder databaseType(List<DatabaseType> databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListDatabaseInsightsRequest buildWithoutInvocationCallback() {
            return new ListDatabaseInsightsRequest(this.compartmentId, this.databaseType, this.databaseId, this.fields, this.limit, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListDatabaseInsightsRequest.Builder(compartmentId=" + this.compartmentId + ", databaseType=" + this.databaseType + ", databaseId=" + this.databaseId + ", fields=" + this.fields + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        DatabaseName("databaseName"),
        DatabaseDisplayName("databaseDisplayName"),
        DatabaseType("databaseType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Fields {
        CompartmentId("compartmentId"),
        DatabaseName("databaseName"),
        DatabaseDisplayName("databaseDisplayName"),
        DatabaseType("databaseType"),
        DatabaseVersion("databaseVersion"),
        DatabaseHostNames("databaseHostNames"),
        FreeformTags("freeformTags"),
        DefinedTags("definedTags");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseType {
        AdwS("ADW-S"),
        AtpS("ATP-S"),
        AdwD("ADW-D"),
        AtpD("ATP-D");

        private final String value;
        private static Map<String, DatabaseType> map;

        private DatabaseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseType: " + key);
        }

        static {
            map = new HashMap<String, DatabaseType>();
            for (DatabaseType v : DatabaseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

