/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.ws.rs.client.Invocation;

public class ListSqlPlansRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String databaseId;
    private String sqlIdentifier;
    private List<Long> planHash;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "databaseId", "sqlIdentifier", "planHash", "page", "opcRequestId"})
    ListSqlPlansRequest(String compartmentId, String databaseId, String sqlIdentifier, List<Long> planHash, String page, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.databaseId = databaseId;
        this.sqlIdentifier = sqlIdentifier;
        this.planHash = planHash;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public List<Long> getPlanHash() {
        return this.planHash;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSqlPlansRequest, Void> {
        private String compartmentId;
        private String databaseId;
        private String sqlIdentifier;
        private List<Long> planHash;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSqlPlansRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.databaseId(o.getDatabaseId());
            this.sqlIdentifier(o.getSqlIdentifier());
            this.planHash(o.getPlanHash());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSqlPlansRequest build() {
            ListSqlPlansRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder sqlIdentifier(String sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            return this;
        }

        public Builder planHash(List<Long> planHash) {
            this.planHash = planHash;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListSqlPlansRequest buildWithoutInvocationCallback() {
            return new ListSqlPlansRequest(this.compartmentId, this.databaseId, this.sqlIdentifier, this.planHash, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListSqlPlansRequest.Builder(compartmentId=" + this.compartmentId + ", databaseId=" + this.databaseId + ", sqlIdentifier=" + this.sqlIdentifier + ", planHash=" + this.planHash + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

