/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.ws.rs.client.Invocation;

public class ListSqlTextsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<String> sqlIdentifier;
    private List<String> databaseId;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "sqlIdentifier", "databaseId", "page", "opcRequestId"})
    ListSqlTextsRequest(String compartmentId, List<String> sqlIdentifier, List<String> databaseId, String page, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.sqlIdentifier = sqlIdentifier;
        this.databaseId = databaseId;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSqlTextsRequest, Void> {
        private String compartmentId;
        private List<String> sqlIdentifier;
        private List<String> databaseId;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSqlTextsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.sqlIdentifier(o.getSqlIdentifier());
            this.databaseId(o.getDatabaseId());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSqlTextsRequest build() {
            ListSqlTextsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder sqlIdentifier(List<String> sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            return this;
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListSqlTextsRequest buildWithoutInvocationCallback() {
            return new ListSqlTextsRequest(this.compartmentId, this.sqlIdentifier, this.databaseId, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListSqlTextsRequest.Builder(compartmentId=" + this.compartmentId + ", sqlIdentifier=" + this.sqlIdentifier + ", databaseId=" + this.databaseId + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

