/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class SummarizeDatabaseInsightResourceCapacityTrendRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String resourceMetric;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private List<DatabaseType> databaseType;
    private List<String> databaseId;
    private UtilizationLevel utilizationLevel;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "resourceMetric", "analysisTimeInterval", "timeIntervalStart", "timeIntervalEnd", "databaseType", "databaseId", "utilizationLevel", "page", "sortOrder", "sortBy", "opcRequestId"})
    SummarizeDatabaseInsightResourceCapacityTrendRequest(String compartmentId, String resourceMetric, String analysisTimeInterval, Date timeIntervalStart, Date timeIntervalEnd, List<DatabaseType> databaseType, List<String> databaseId, UtilizationLevel utilizationLevel, String page, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.resourceMetric = resourceMetric;
        this.analysisTimeInterval = analysisTimeInterval;
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.databaseType = databaseType;
        this.databaseId = databaseId;
        this.utilizationLevel = utilizationLevel;
        this.page = page;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceMetric() {
        return this.resourceMetric;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public List<DatabaseType> getDatabaseType() {
        return this.databaseType;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public UtilizationLevel getUtilizationLevel() {
        return this.utilizationLevel;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeDatabaseInsightResourceCapacityTrendRequest, Void> {
        private String compartmentId;
        private String resourceMetric;
        private String analysisTimeInterval;
        private Date timeIntervalStart;
        private Date timeIntervalEnd;
        private List<DatabaseType> databaseType;
        private List<String> databaseId;
        private UtilizationLevel utilizationLevel;
        private String page;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeDatabaseInsightResourceCapacityTrendRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.resourceMetric(o.getResourceMetric());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.databaseType(o.getDatabaseType());
            this.databaseId(o.getDatabaseId());
            this.utilizationLevel(o.getUtilizationLevel());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeDatabaseInsightResourceCapacityTrendRequest build() {
            SummarizeDatabaseInsightResourceCapacityTrendRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceMetric(String resourceMetric) {
            this.resourceMetric = resourceMetric;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder databaseType(List<DatabaseType> databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder utilizationLevel(UtilizationLevel utilizationLevel) {
            this.utilizationLevel = utilizationLevel;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public SummarizeDatabaseInsightResourceCapacityTrendRequest buildWithoutInvocationCallback() {
            return new SummarizeDatabaseInsightResourceCapacityTrendRequest(this.compartmentId, this.resourceMetric, this.analysisTimeInterval, this.timeIntervalStart, this.timeIntervalEnd, this.databaseType, this.databaseId, this.utilizationLevel, this.page, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "SummarizeDatabaseInsightResourceCapacityTrendRequest.Builder(compartmentId=" + this.compartmentId + ", resourceMetric=" + this.resourceMetric + ", analysisTimeInterval=" + this.analysisTimeInterval + ", timeIntervalStart=" + this.timeIntervalStart + ", timeIntervalEnd=" + this.timeIntervalEnd + ", databaseType=" + this.databaseType + ", databaseId=" + this.databaseId + ", utilizationLevel=" + (Object)((Object)this.utilizationLevel) + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        EndTimestamp("endTimestamp"),
        Capacity("capacity"),
        BaseCapacity("baseCapacity");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum UtilizationLevel {
        HighUtilization("HIGH_UTILIZATION"),
        LowUtilization("LOW_UTILIZATION"),
        MediumHighUtilization("MEDIUM_HIGH_UTILIZATION"),
        MediumLowUtilization("MEDIUM_LOW_UTILIZATION");

        private final String value;
        private static Map<String, UtilizationLevel> map;

        private UtilizationLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UtilizationLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UtilizationLevel: " + key);
        }

        static {
            map = new HashMap<String, UtilizationLevel>();
            for (UtilizationLevel v : UtilizationLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseType {
        AdwS("ADW-S"),
        AtpS("ATP-S"),
        AdwD("ADW-D"),
        AtpD("ATP-D");

        private final String value;
        private static Map<String, DatabaseType> map;

        private DatabaseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseType: " + key);
        }

        static {
            map = new HashMap<String, DatabaseType>();
            for (DatabaseType v : DatabaseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

