/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class SummarizeDatabaseInsightResourceForecastTrendRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String resourceMetric;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private List<DatabaseType> databaseType;
    private List<String> databaseId;
    private Statistic statistic;
    private Integer forecastDays;
    private ForecastModel forecastModel;
    private UtilizationLevel utilizationLevel;
    private Integer confidence;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "resourceMetric", "analysisTimeInterval", "timeIntervalStart", "timeIntervalEnd", "databaseType", "databaseId", "statistic", "forecastDays", "forecastModel", "utilizationLevel", "confidence", "page", "opcRequestId"})
    SummarizeDatabaseInsightResourceForecastTrendRequest(String compartmentId, String resourceMetric, String analysisTimeInterval, Date timeIntervalStart, Date timeIntervalEnd, List<DatabaseType> databaseType, List<String> databaseId, Statistic statistic, Integer forecastDays, ForecastModel forecastModel, UtilizationLevel utilizationLevel, Integer confidence, String page, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.resourceMetric = resourceMetric;
        this.analysisTimeInterval = analysisTimeInterval;
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.databaseType = databaseType;
        this.databaseId = databaseId;
        this.statistic = statistic;
        this.forecastDays = forecastDays;
        this.forecastModel = forecastModel;
        this.utilizationLevel = utilizationLevel;
        this.confidence = confidence;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceMetric() {
        return this.resourceMetric;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public List<DatabaseType> getDatabaseType() {
        return this.databaseType;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    public Integer getForecastDays() {
        return this.forecastDays;
    }

    public ForecastModel getForecastModel() {
        return this.forecastModel;
    }

    public UtilizationLevel getUtilizationLevel() {
        return this.utilizationLevel;
    }

    public Integer getConfidence() {
        return this.confidence;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeDatabaseInsightResourceForecastTrendRequest, Void> {
        private String compartmentId;
        private String resourceMetric;
        private String analysisTimeInterval;
        private Date timeIntervalStart;
        private Date timeIntervalEnd;
        private List<DatabaseType> databaseType;
        private List<String> databaseId;
        private Statistic statistic;
        private Integer forecastDays;
        private ForecastModel forecastModel;
        private UtilizationLevel utilizationLevel;
        private Integer confidence;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeDatabaseInsightResourceForecastTrendRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.resourceMetric(o.getResourceMetric());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.databaseType(o.getDatabaseType());
            this.databaseId(o.getDatabaseId());
            this.statistic(o.getStatistic());
            this.forecastDays(o.getForecastDays());
            this.forecastModel(o.getForecastModel());
            this.utilizationLevel(o.getUtilizationLevel());
            this.confidence(o.getConfidence());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeDatabaseInsightResourceForecastTrendRequest build() {
            SummarizeDatabaseInsightResourceForecastTrendRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceMetric(String resourceMetric) {
            this.resourceMetric = resourceMetric;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder databaseType(List<DatabaseType> databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder statistic(Statistic statistic) {
            this.statistic = statistic;
            return this;
        }

        public Builder forecastDays(Integer forecastDays) {
            this.forecastDays = forecastDays;
            return this;
        }

        public Builder forecastModel(ForecastModel forecastModel) {
            this.forecastModel = forecastModel;
            return this;
        }

        public Builder utilizationLevel(UtilizationLevel utilizationLevel) {
            this.utilizationLevel = utilizationLevel;
            return this;
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public SummarizeDatabaseInsightResourceForecastTrendRequest buildWithoutInvocationCallback() {
            return new SummarizeDatabaseInsightResourceForecastTrendRequest(this.compartmentId, this.resourceMetric, this.analysisTimeInterval, this.timeIntervalStart, this.timeIntervalEnd, this.databaseType, this.databaseId, this.statistic, this.forecastDays, this.forecastModel, this.utilizationLevel, this.confidence, this.page, this.opcRequestId);
        }

        public String toString() {
            return "SummarizeDatabaseInsightResourceForecastTrendRequest.Builder(compartmentId=" + this.compartmentId + ", resourceMetric=" + this.resourceMetric + ", analysisTimeInterval=" + this.analysisTimeInterval + ", timeIntervalStart=" + this.timeIntervalStart + ", timeIntervalEnd=" + this.timeIntervalEnd + ", databaseType=" + this.databaseType + ", databaseId=" + this.databaseId + ", statistic=" + (Object)((Object)this.statistic) + ", forecastDays=" + this.forecastDays + ", forecastModel=" + (Object)((Object)this.forecastModel) + ", utilizationLevel=" + (Object)((Object)this.utilizationLevel) + ", confidence=" + this.confidence + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum UtilizationLevel {
        HighUtilization("HIGH_UTILIZATION"),
        LowUtilization("LOW_UTILIZATION"),
        MediumHighUtilization("MEDIUM_HIGH_UTILIZATION"),
        MediumLowUtilization("MEDIUM_LOW_UTILIZATION");

        private final String value;
        private static Map<String, UtilizationLevel> map;

        private UtilizationLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UtilizationLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UtilizationLevel: " + key);
        }

        static {
            map = new HashMap<String, UtilizationLevel>();
            for (UtilizationLevel v : UtilizationLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ForecastModel {
        Linear("LINEAR"),
        MlAuto("ML_AUTO"),
        MlNoAuto("ML_NO_AUTO");

        private final String value;
        private static Map<String, ForecastModel> map;

        private ForecastModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ForecastModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ForecastModel: " + key);
        }

        static {
            map = new HashMap<String, ForecastModel>();
            for (ForecastModel v : ForecastModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Statistic {
        Avg("AVG"),
        Max("MAX");

        private final String value;
        private static Map<String, Statistic> map;

        private Statistic(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Statistic create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Statistic: " + key);
        }

        static {
            map = new HashMap<String, Statistic>();
            for (Statistic v : Statistic.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseType {
        AdwS("ADW-S"),
        AtpS("ATP-S"),
        AdwD("ADW-D"),
        AtpD("ATP-D");

        private final String value;
        private static Map<String, DatabaseType> map;

        private DatabaseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseType: " + key);
        }

        static {
            map = new HashMap<String, DatabaseType>();
            for (DatabaseType v : DatabaseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

