/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class SummarizeDatabaseInsightResourceUsageRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String resourceMetric;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private List<DatabaseType> databaseType;
    private List<String> databaseId;
    private String page;
    private Integer percentile;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "resourceMetric", "analysisTimeInterval", "timeIntervalStart", "timeIntervalEnd", "databaseType", "databaseId", "page", "percentile", "opcRequestId"})
    SummarizeDatabaseInsightResourceUsageRequest(String compartmentId, String resourceMetric, String analysisTimeInterval, Date timeIntervalStart, Date timeIntervalEnd, List<DatabaseType> databaseType, List<String> databaseId, String page, Integer percentile, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.resourceMetric = resourceMetric;
        this.analysisTimeInterval = analysisTimeInterval;
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.databaseType = databaseType;
        this.databaseId = databaseId;
        this.page = page;
        this.percentile = percentile;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceMetric() {
        return this.resourceMetric;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public List<DatabaseType> getDatabaseType() {
        return this.databaseType;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getPercentile() {
        return this.percentile;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeDatabaseInsightResourceUsageRequest, Void> {
        private String compartmentId;
        private String resourceMetric;
        private String analysisTimeInterval;
        private Date timeIntervalStart;
        private Date timeIntervalEnd;
        private List<DatabaseType> databaseType;
        private List<String> databaseId;
        private String page;
        private Integer percentile;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeDatabaseInsightResourceUsageRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.resourceMetric(o.getResourceMetric());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.databaseType(o.getDatabaseType());
            this.databaseId(o.getDatabaseId());
            this.page(o.getPage());
            this.percentile(o.getPercentile());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeDatabaseInsightResourceUsageRequest build() {
            SummarizeDatabaseInsightResourceUsageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder resourceMetric(String resourceMetric) {
            this.resourceMetric = resourceMetric;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder databaseType(List<DatabaseType> databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder percentile(Integer percentile) {
            this.percentile = percentile;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public SummarizeDatabaseInsightResourceUsageRequest buildWithoutInvocationCallback() {
            return new SummarizeDatabaseInsightResourceUsageRequest(this.compartmentId, this.resourceMetric, this.analysisTimeInterval, this.timeIntervalStart, this.timeIntervalEnd, this.databaseType, this.databaseId, this.page, this.percentile, this.opcRequestId);
        }

        public String toString() {
            return "SummarizeDatabaseInsightResourceUsageRequest.Builder(compartmentId=" + this.compartmentId + ", resourceMetric=" + this.resourceMetric + ", analysisTimeInterval=" + this.analysisTimeInterval + ", timeIntervalStart=" + this.timeIntervalStart + ", timeIntervalEnd=" + this.timeIntervalEnd + ", databaseType=" + this.databaseType + ", databaseId=" + this.databaseId + ", page=" + this.page + ", percentile=" + this.percentile + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum DatabaseType {
        AdwS("ADW-S"),
        AtpS("ATP-S"),
        AdwD("ADW-D"),
        AtpD("ATP-D");

        private final String value;
        private static Map<String, DatabaseType> map;

        private DatabaseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseType: " + key);
        }

        static {
            map = new HashMap<String, DatabaseType>();
            for (DatabaseType v : DatabaseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

