/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class SummarizeSqlInsightsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<DatabaseType> databaseType;
    private List<String> databaseId;
    private Double databaseTimePctGreaterThan;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "databaseType", "databaseId", "databaseTimePctGreaterThan", "analysisTimeInterval", "timeIntervalStart", "timeIntervalEnd", "page", "opcRequestId"})
    SummarizeSqlInsightsRequest(String compartmentId, List<DatabaseType> databaseType, List<String> databaseId, Double databaseTimePctGreaterThan, String analysisTimeInterval, Date timeIntervalStart, Date timeIntervalEnd, String page, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.databaseType = databaseType;
        this.databaseId = databaseId;
        this.databaseTimePctGreaterThan = databaseTimePctGreaterThan;
        this.analysisTimeInterval = analysisTimeInterval;
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<DatabaseType> getDatabaseType() {
        return this.databaseType;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public Double getDatabaseTimePctGreaterThan() {
        return this.databaseTimePctGreaterThan;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeSqlInsightsRequest, Void> {
        private String compartmentId;
        private List<DatabaseType> databaseType;
        private List<String> databaseId;
        private Double databaseTimePctGreaterThan;
        private String analysisTimeInterval;
        private Date timeIntervalStart;
        private Date timeIntervalEnd;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeSqlInsightsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.databaseType(o.getDatabaseType());
            this.databaseId(o.getDatabaseId());
            this.databaseTimePctGreaterThan(o.getDatabaseTimePctGreaterThan());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeSqlInsightsRequest build() {
            SummarizeSqlInsightsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder databaseType(List<DatabaseType> databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder databaseTimePctGreaterThan(Double databaseTimePctGreaterThan) {
            this.databaseTimePctGreaterThan = databaseTimePctGreaterThan;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public SummarizeSqlInsightsRequest buildWithoutInvocationCallback() {
            return new SummarizeSqlInsightsRequest(this.compartmentId, this.databaseType, this.databaseId, this.databaseTimePctGreaterThan, this.analysisTimeInterval, this.timeIntervalStart, this.timeIntervalEnd, this.page, this.opcRequestId);
        }

        public String toString() {
            return "SummarizeSqlInsightsRequest.Builder(compartmentId=" + this.compartmentId + ", databaseType=" + this.databaseType + ", databaseId=" + this.databaseId + ", databaseTimePctGreaterThan=" + this.databaseTimePctGreaterThan + ", analysisTimeInterval=" + this.analysisTimeInterval + ", timeIntervalStart=" + this.timeIntervalStart + ", timeIntervalEnd=" + this.timeIntervalEnd + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum DatabaseType {
        AdwS("ADW-S"),
        AtpS("ATP-S"),
        AdwD("ADW-D"),
        AtpD("ATP-D");

        private final String value;
        private static Map<String, DatabaseType> map;

        private DatabaseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseType: " + key);
        }

        static {
            map = new HashMap<String, DatabaseType>();
            for (DatabaseType v : DatabaseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

