/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class SummarizeSqlStatisticsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<DatabaseType> databaseType;
    private List<String> databaseId;
    private Double databaseTimePctGreaterThan;
    private List<String> sqlIdentifier;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private List<Category> category;

    @ConstructorProperties(value={"compartmentId", "databaseType", "databaseId", "databaseTimePctGreaterThan", "sqlIdentifier", "analysisTimeInterval", "timeIntervalStart", "timeIntervalEnd", "limit", "page", "opcRequestId", "sortOrder", "sortBy", "category"})
    SummarizeSqlStatisticsRequest(String compartmentId, List<DatabaseType> databaseType, List<String> databaseId, Double databaseTimePctGreaterThan, List<String> sqlIdentifier, String analysisTimeInterval, Date timeIntervalStart, Date timeIntervalEnd, Integer limit, String page, String opcRequestId, SortOrder sortOrder, SortBy sortBy, List<Category> category) {
        this.compartmentId = compartmentId;
        this.databaseType = databaseType;
        this.databaseId = databaseId;
        this.databaseTimePctGreaterThan = databaseTimePctGreaterThan;
        this.sqlIdentifier = sqlIdentifier;
        this.analysisTimeInterval = analysisTimeInterval;
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.category = category;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<DatabaseType> getDatabaseType() {
        return this.databaseType;
    }

    public List<String> getDatabaseId() {
        return this.databaseId;
    }

    public Double getDatabaseTimePctGreaterThan() {
        return this.databaseTimePctGreaterThan;
    }

    public List<String> getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public List<Category> getCategory() {
        return this.category;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeSqlStatisticsRequest, Void> {
        private String compartmentId;
        private List<DatabaseType> databaseType;
        private List<String> databaseId;
        private Double databaseTimePctGreaterThan;
        private List<String> sqlIdentifier;
        private String analysisTimeInterval;
        private Date timeIntervalStart;
        private Date timeIntervalEnd;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private List<Category> category;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeSqlStatisticsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.databaseType(o.getDatabaseType());
            this.databaseId(o.getDatabaseId());
            this.databaseTimePctGreaterThan(o.getDatabaseTimePctGreaterThan());
            this.sqlIdentifier(o.getSqlIdentifier());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.category(o.getCategory());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeSqlStatisticsRequest build() {
            SummarizeSqlStatisticsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder databaseType(List<DatabaseType> databaseType) {
            this.databaseType = databaseType;
            return this;
        }

        public Builder databaseId(List<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder databaseTimePctGreaterThan(Double databaseTimePctGreaterThan) {
            this.databaseTimePctGreaterThan = databaseTimePctGreaterThan;
            return this;
        }

        public Builder sqlIdentifier(List<String> sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder category(List<Category> category) {
            this.category = category;
            return this;
        }

        public SummarizeSqlStatisticsRequest buildWithoutInvocationCallback() {
            return new SummarizeSqlStatisticsRequest(this.compartmentId, this.databaseType, this.databaseId, this.databaseTimePctGreaterThan, this.sqlIdentifier, this.analysisTimeInterval, this.timeIntervalStart, this.timeIntervalEnd, this.limit, this.page, this.opcRequestId, this.sortOrder, this.sortBy, this.category);
        }

        public String toString() {
            return "SummarizeSqlStatisticsRequest.Builder(compartmentId=" + this.compartmentId + ", databaseType=" + this.databaseType + ", databaseId=" + this.databaseId + ", databaseTimePctGreaterThan=" + this.databaseTimePctGreaterThan + ", sqlIdentifier=" + this.sqlIdentifier + ", analysisTimeInterval=" + this.analysisTimeInterval + ", timeIntervalStart=" + this.timeIntervalStart + ", timeIntervalEnd=" + this.timeIntervalEnd + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", category=" + this.category + ")";
        }
    }

    public static enum Category {
        Degrading("DEGRADING"),
        Variant("VARIANT"),
        Inefficient("INEFFICIENT"),
        ChangingPlans("CHANGING_PLANS"),
        Improving("IMPROVING"),
        DegradingVariant("DEGRADING_VARIANT"),
        DegradingInefficient("DEGRADING_INEFFICIENT"),
        DegradingChangingPlans("DEGRADING_CHANGING_PLANS"),
        DegradingIncreasingIo("DEGRADING_INCREASING_IO"),
        DegradingIncreasingCpu("DEGRADING_INCREASING_CPU"),
        DegradingIncreasingInefficientWait("DEGRADING_INCREASING_INEFFICIENT_WAIT"),
        DegradingChangingPlansAndIncreasingIo("DEGRADING_CHANGING_PLANS_AND_INCREASING_IO"),
        DegradingChangingPlansAndIncreasingCpu("DEGRADING_CHANGING_PLANS_AND_INCREASING_CPU"),
        DegradingChangingPlansAndIncreasingInefficientWait("DEGRADING_CHANGING_PLANS_AND_INCREASING_INEFFICIENT_WAIT"),
        VariantInefficient("VARIANT_INEFFICIENT"),
        VariantChangingPlans("VARIANT_CHANGING_PLANS"),
        VariantIncreasingIo("VARIANT_INCREASING_IO"),
        VariantIncreasingCpu("VARIANT_INCREASING_CPU"),
        VariantIncreasingInefficientWait("VARIANT_INCREASING_INEFFICIENT_WAIT"),
        VariantChangingPlansAndIncreasingIo("VARIANT_CHANGING_PLANS_AND_INCREASING_IO"),
        VariantChangingPlansAndIncreasingCpu("VARIANT_CHANGING_PLANS_AND_INCREASING_CPU"),
        VariantChangingPlansAndIncreasingInefficientWait("VARIANT_CHANGING_PLANS_AND_INCREASING_INEFFICIENT_WAIT"),
        InefficientChangingPlans("INEFFICIENT_CHANGING_PLANS"),
        InefficientIncreasingInefficientWait("INEFFICIENT_INCREASING_INEFFICIENT_WAIT"),
        InefficientChangingPlansAndIncreasingInefficientWait("INEFFICIENT_CHANGING_PLANS_AND_INCREASING_INEFFICIENT_WAIT");

        private final String value;
        private static Map<String, Category> map;

        private Category(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Category create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Category: " + key);
        }

        static {
            map = new HashMap<String, Category>();
            for (Category v : Category.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        DatabaseTimeInSec("databaseTimeInSec"),
        ExecutionsPerHour("executionsPerHour"),
        ExecutionsCount("executionsCount"),
        CpuTimeInSec("cpuTimeInSec"),
        IoTimeInSec("ioTimeInSec"),
        InefficientWaitTimeInSec("inefficientWaitTimeInSec"),
        ResponseTimeInSec("responseTimeInSec"),
        PlanCount("planCount"),
        Variability("variability"),
        AverageActiveSessions("averageActiveSessions"),
        DatabaseTimePct("databaseTimePct"),
        InefficiencyInPct("inefficiencyInPct"),
        ChangeInCpuTimeInPct("changeInCpuTimeInPct"),
        ChangeInIoTimeInPct("changeInIoTimeInPct"),
        ChangeInInefficientWaitTimeInPct("changeInInefficientWaitTimeInPct"),
        ChangeInResponseTimeInPct("changeInResponseTimeInPct"),
        ChangeInAverageActiveSessionsInPct("changeInAverageActiveSessionsInPct"),
        ChangeInExecutionsPerHourInPct("changeInExecutionsPerHourInPct"),
        ChangeInInefficiencyInPct("changeInInefficiencyInPct");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseType {
        AdwS("ADW-S"),
        AtpS("ATP-S"),
        AdwD("ADW-D"),
        AtpD("ATP-D");

        private final String value;
        private static Map<String, DatabaseType> map;

        private DatabaseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DatabaseType: " + key);
        }

        static {
            map = new HashMap<String, DatabaseType>();
            for (DatabaseType v : DatabaseType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

