/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi;

import com.oracle.bmc.opsi.OperationsInsights;
import com.oracle.bmc.opsi.model.AwrHubLifecycleState;
import com.oracle.bmc.opsi.model.ExadataInsightLifecycleState;
import com.oracle.bmc.opsi.model.LifecycleState;
import com.oracle.bmc.opsi.model.OperationsInsightsPrivateEndpointLifecycleState;
import com.oracle.bmc.opsi.model.OperationsInsightsWarehouseLifecycleState;
import com.oracle.bmc.opsi.model.OperationsInsightsWarehouseUserLifecycleState;
import com.oracle.bmc.opsi.model.OpsiConfigurationLifecycleState;
import com.oracle.bmc.opsi.requests.GetAwrHubRequest;
import com.oracle.bmc.opsi.requests.GetDatabaseInsightRequest;
import com.oracle.bmc.opsi.requests.GetEnterpriseManagerBridgeRequest;
import com.oracle.bmc.opsi.requests.GetExadataInsightRequest;
import com.oracle.bmc.opsi.requests.GetHostInsightRequest;
import com.oracle.bmc.opsi.requests.GetOperationsInsightsPrivateEndpointRequest;
import com.oracle.bmc.opsi.requests.GetOperationsInsightsWarehouseRequest;
import com.oracle.bmc.opsi.requests.GetOperationsInsightsWarehouseUserRequest;
import com.oracle.bmc.opsi.requests.GetOpsiConfigurationRequest;
import com.oracle.bmc.opsi.requests.GetWorkRequestRequest;
import com.oracle.bmc.opsi.responses.GetAwrHubResponse;
import com.oracle.bmc.opsi.responses.GetDatabaseInsightResponse;
import com.oracle.bmc.opsi.responses.GetEnterpriseManagerBridgeResponse;
import com.oracle.bmc.opsi.responses.GetExadataInsightResponse;
import com.oracle.bmc.opsi.responses.GetHostInsightResponse;
import com.oracle.bmc.opsi.responses.GetOperationsInsightsPrivateEndpointResponse;
import com.oracle.bmc.opsi.responses.GetOperationsInsightsWarehouseResponse;
import com.oracle.bmc.opsi.responses.GetOperationsInsightsWarehouseUserResponse;
import com.oracle.bmc.opsi.responses.GetOpsiConfigurationResponse;
import com.oracle.bmc.opsi.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OperationsInsightsWaiters {
    private final ExecutorService executorService;
    private final OperationsInsights client;

    public OperationsInsightsWaiters(ExecutorService executorService, OperationsInsights client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAwrHubRequest, GetAwrHubResponse> forAwrHub(GetAwrHubRequest request, AwrHubLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAwrHub(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAwrHubRequest, GetAwrHubResponse> forAwrHub(GetAwrHubRequest request, AwrHubLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAwrHub(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAwrHubRequest, GetAwrHubResponse> forAwrHub(GetAwrHubRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AwrHubLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAwrHub(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAwrHubRequest, GetAwrHubResponse> forAwrHub(BmcGenericWaiter waiter, GetAwrHubRequest request, AwrHubLifecycleState ... targetStates) {
        final HashSet<AwrHubLifecycleState> targetStatesSet = new HashSet<AwrHubLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAwrHubRequest, GetAwrHubResponse>(){

            @Override
            public GetAwrHubResponse apply(GetAwrHubRequest request) {
                return OperationsInsightsWaiters.this.client.getAwrHub(request);
            }
        }, (Predicate)new Predicate<GetAwrHubResponse>(){

            @Override
            public boolean test(GetAwrHubResponse response) {
                return targetStatesSet.contains((Object)response.getAwrHub().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AwrHubLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDatabaseInsightRequest, GetDatabaseInsightResponse> forDatabaseInsight(GetDatabaseInsightRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseInsight(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatabaseInsightRequest, GetDatabaseInsightResponse> forDatabaseInsight(GetDatabaseInsightRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDatabaseInsight(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatabaseInsightRequest, GetDatabaseInsightResponse> forDatabaseInsight(GetDatabaseInsightRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseInsight(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatabaseInsightRequest, GetDatabaseInsightResponse> forDatabaseInsight(BmcGenericWaiter waiter, GetDatabaseInsightRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDatabaseInsightRequest, GetDatabaseInsightResponse>(){

            @Override
            public GetDatabaseInsightResponse apply(GetDatabaseInsightRequest request) {
                return OperationsInsightsWaiters.this.client.getDatabaseInsight(request);
            }
        }, (Predicate)new Predicate<GetDatabaseInsightResponse>(){

            @Override
            public boolean test(GetDatabaseInsightResponse response) {
                return targetStatesSet.contains((Object)response.getDatabaseInsight().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetEnterpriseManagerBridgeRequest, GetEnterpriseManagerBridgeResponse> forEnterpriseManagerBridge(GetEnterpriseManagerBridgeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEnterpriseManagerBridge(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEnterpriseManagerBridgeRequest, GetEnterpriseManagerBridgeResponse> forEnterpriseManagerBridge(GetEnterpriseManagerBridgeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEnterpriseManagerBridge(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEnterpriseManagerBridgeRequest, GetEnterpriseManagerBridgeResponse> forEnterpriseManagerBridge(GetEnterpriseManagerBridgeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEnterpriseManagerBridge(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEnterpriseManagerBridgeRequest, GetEnterpriseManagerBridgeResponse> forEnterpriseManagerBridge(BmcGenericWaiter waiter, GetEnterpriseManagerBridgeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEnterpriseManagerBridgeRequest, GetEnterpriseManagerBridgeResponse>(){

            @Override
            public GetEnterpriseManagerBridgeResponse apply(GetEnterpriseManagerBridgeRequest request) {
                return OperationsInsightsWaiters.this.client.getEnterpriseManagerBridge(request);
            }
        }, (Predicate)new Predicate<GetEnterpriseManagerBridgeResponse>(){

            @Override
            public boolean test(GetEnterpriseManagerBridgeResponse response) {
                return targetStatesSet.contains((Object)response.getEnterpriseManagerBridge().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExadataInsightRequest, GetExadataInsightResponse> forExadataInsight(GetExadataInsightRequest request, ExadataInsightLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExadataInsight(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExadataInsightRequest, GetExadataInsightResponse> forExadataInsight(GetExadataInsightRequest request, ExadataInsightLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExadataInsight(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExadataInsightRequest, GetExadataInsightResponse> forExadataInsight(GetExadataInsightRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExadataInsightLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExadataInsight(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExadataInsightRequest, GetExadataInsightResponse> forExadataInsight(BmcGenericWaiter waiter, GetExadataInsightRequest request, ExadataInsightLifecycleState ... targetStates) {
        final HashSet<ExadataInsightLifecycleState> targetStatesSet = new HashSet<ExadataInsightLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExadataInsightRequest, GetExadataInsightResponse>(){

            @Override
            public GetExadataInsightResponse apply(GetExadataInsightRequest request) {
                return OperationsInsightsWaiters.this.client.getExadataInsight(request);
            }
        }, (Predicate)new Predicate<GetExadataInsightResponse>(){

            @Override
            public boolean test(GetExadataInsightResponse response) {
                return targetStatesSet.contains((Object)response.getExadataInsight().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExadataInsightLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHostInsightRequest, GetHostInsightResponse> forHostInsight(GetHostInsightRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostInsight(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHostInsightRequest, GetHostInsightResponse> forHostInsight(GetHostInsightRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHostInsight(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHostInsightRequest, GetHostInsightResponse> forHostInsight(GetHostInsightRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostInsight(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHostInsightRequest, GetHostInsightResponse> forHostInsight(BmcGenericWaiter waiter, GetHostInsightRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHostInsightRequest, GetHostInsightResponse>(){

            @Override
            public GetHostInsightResponse apply(GetHostInsightRequest request) {
                return OperationsInsightsWaiters.this.client.getHostInsight(request);
            }
        }, (Predicate)new Predicate<GetHostInsightResponse>(){

            @Override
            public boolean test(GetHostInsightResponse response) {
                return targetStatesSet.contains((Object)response.getHostInsight().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOperationsInsightsPrivateEndpointRequest, GetOperationsInsightsPrivateEndpointResponse> forOperationsInsightsPrivateEndpoint(GetOperationsInsightsPrivateEndpointRequest request, OperationsInsightsPrivateEndpointLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperationsInsightsPrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOperationsInsightsPrivateEndpointRequest, GetOperationsInsightsPrivateEndpointResponse> forOperationsInsightsPrivateEndpoint(GetOperationsInsightsPrivateEndpointRequest request, OperationsInsightsPrivateEndpointLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOperationsInsightsPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOperationsInsightsPrivateEndpointRequest, GetOperationsInsightsPrivateEndpointResponse> forOperationsInsightsPrivateEndpoint(GetOperationsInsightsPrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OperationsInsightsPrivateEndpointLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperationsInsightsPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOperationsInsightsPrivateEndpointRequest, GetOperationsInsightsPrivateEndpointResponse> forOperationsInsightsPrivateEndpoint(BmcGenericWaiter waiter, GetOperationsInsightsPrivateEndpointRequest request, OperationsInsightsPrivateEndpointLifecycleState ... targetStates) {
        final HashSet<OperationsInsightsPrivateEndpointLifecycleState> targetStatesSet = new HashSet<OperationsInsightsPrivateEndpointLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOperationsInsightsPrivateEndpointRequest, GetOperationsInsightsPrivateEndpointResponse>(){

            @Override
            public GetOperationsInsightsPrivateEndpointResponse apply(GetOperationsInsightsPrivateEndpointRequest request) {
                return OperationsInsightsWaiters.this.client.getOperationsInsightsPrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetOperationsInsightsPrivateEndpointResponse>(){

            @Override
            public boolean test(GetOperationsInsightsPrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getOperationsInsightsPrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OperationsInsightsPrivateEndpointLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOperationsInsightsWarehouseRequest, GetOperationsInsightsWarehouseResponse> forOperationsInsightsWarehouse(GetOperationsInsightsWarehouseRequest request, OperationsInsightsWarehouseLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperationsInsightsWarehouse(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOperationsInsightsWarehouseRequest, GetOperationsInsightsWarehouseResponse> forOperationsInsightsWarehouse(GetOperationsInsightsWarehouseRequest request, OperationsInsightsWarehouseLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOperationsInsightsWarehouse(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOperationsInsightsWarehouseRequest, GetOperationsInsightsWarehouseResponse> forOperationsInsightsWarehouse(GetOperationsInsightsWarehouseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OperationsInsightsWarehouseLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperationsInsightsWarehouse(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOperationsInsightsWarehouseRequest, GetOperationsInsightsWarehouseResponse> forOperationsInsightsWarehouse(BmcGenericWaiter waiter, GetOperationsInsightsWarehouseRequest request, OperationsInsightsWarehouseLifecycleState ... targetStates) {
        final HashSet<OperationsInsightsWarehouseLifecycleState> targetStatesSet = new HashSet<OperationsInsightsWarehouseLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOperationsInsightsWarehouseRequest, GetOperationsInsightsWarehouseResponse>(){

            @Override
            public GetOperationsInsightsWarehouseResponse apply(GetOperationsInsightsWarehouseRequest request) {
                return OperationsInsightsWaiters.this.client.getOperationsInsightsWarehouse(request);
            }
        }, (Predicate)new Predicate<GetOperationsInsightsWarehouseResponse>(){

            @Override
            public boolean test(GetOperationsInsightsWarehouseResponse response) {
                return targetStatesSet.contains((Object)response.getOperationsInsightsWarehouse().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OperationsInsightsWarehouseLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOperationsInsightsWarehouseUserRequest, GetOperationsInsightsWarehouseUserResponse> forOperationsInsightsWarehouseUser(GetOperationsInsightsWarehouseUserRequest request, OperationsInsightsWarehouseUserLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperationsInsightsWarehouseUser(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOperationsInsightsWarehouseUserRequest, GetOperationsInsightsWarehouseUserResponse> forOperationsInsightsWarehouseUser(GetOperationsInsightsWarehouseUserRequest request, OperationsInsightsWarehouseUserLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOperationsInsightsWarehouseUser(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOperationsInsightsWarehouseUserRequest, GetOperationsInsightsWarehouseUserResponse> forOperationsInsightsWarehouseUser(GetOperationsInsightsWarehouseUserRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OperationsInsightsWarehouseUserLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOperationsInsightsWarehouseUser(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOperationsInsightsWarehouseUserRequest, GetOperationsInsightsWarehouseUserResponse> forOperationsInsightsWarehouseUser(BmcGenericWaiter waiter, GetOperationsInsightsWarehouseUserRequest request, OperationsInsightsWarehouseUserLifecycleState ... targetStates) {
        final HashSet<OperationsInsightsWarehouseUserLifecycleState> targetStatesSet = new HashSet<OperationsInsightsWarehouseUserLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOperationsInsightsWarehouseUserRequest, GetOperationsInsightsWarehouseUserResponse>(){

            @Override
            public GetOperationsInsightsWarehouseUserResponse apply(GetOperationsInsightsWarehouseUserRequest request) {
                return OperationsInsightsWaiters.this.client.getOperationsInsightsWarehouseUser(request);
            }
        }, (Predicate)new Predicate<GetOperationsInsightsWarehouseUserResponse>(){

            @Override
            public boolean test(GetOperationsInsightsWarehouseUserResponse response) {
                return targetStatesSet.contains((Object)response.getOperationsInsightsWarehouseUser().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OperationsInsightsWarehouseUserLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOpsiConfigurationRequest, GetOpsiConfigurationResponse> forOpsiConfiguration(GetOpsiConfigurationRequest request, OpsiConfigurationLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOpsiConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOpsiConfigurationRequest, GetOpsiConfigurationResponse> forOpsiConfiguration(GetOpsiConfigurationRequest request, OpsiConfigurationLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOpsiConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOpsiConfigurationRequest, GetOpsiConfigurationResponse> forOpsiConfiguration(GetOpsiConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OpsiConfigurationLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOpsiConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOpsiConfigurationRequest, GetOpsiConfigurationResponse> forOpsiConfiguration(BmcGenericWaiter waiter, GetOpsiConfigurationRequest request, OpsiConfigurationLifecycleState ... targetStates) {
        final HashSet<OpsiConfigurationLifecycleState> targetStatesSet = new HashSet<OpsiConfigurationLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOpsiConfigurationRequest, GetOpsiConfigurationResponse>(){

            @Override
            public GetOpsiConfigurationResponse apply(GetOpsiConfigurationRequest request) {
                return OperationsInsightsWaiters.this.client.getOpsiConfiguration(request);
            }
        }, (Predicate)new Predicate<GetOpsiConfigurationResponse>(){

            @Override
            public boolean test(GetOpsiConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getOpsiConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OpsiConfigurationLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return OperationsInsightsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

