/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostPerformanceMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostFilesystemUsage
extends HostPerformanceMetricGroup {
    @JsonProperty(value="mountPoint")
    private final String mountPoint;
    @JsonProperty(value="fileSystemUsageInGB")
    private final Double fileSystemUsageInGB;
    @JsonProperty(value="fileSystemAvailInPercent")
    private final Double fileSystemAvailInPercent;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostFilesystemUsage(Date timeCollected, String mountPoint, Double fileSystemUsageInGB, Double fileSystemAvailInPercent) {
        super(timeCollected);
        this.mountPoint = mountPoint;
        this.fileSystemUsageInGB = fileSystemUsageInGB;
        this.fileSystemAvailInPercent = fileSystemAvailInPercent;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public Double getFileSystemUsageInGB() {
        return this.fileSystemUsageInGB;
    }

    public Double getFileSystemAvailInPercent() {
        return this.fileSystemAvailInPercent;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostFilesystemUsage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", mountPoint=").append(String.valueOf(this.mountPoint));
        sb.append(", fileSystemUsageInGB=").append(String.valueOf(this.fileSystemUsageInGB));
        sb.append(", fileSystemAvailInPercent=").append(String.valueOf(this.fileSystemAvailInPercent));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostFilesystemUsage)) {
            return false;
        }
        HostFilesystemUsage other = (HostFilesystemUsage)((Object)o);
        return Objects.equals(this.mountPoint, other.mountPoint) && Objects.equals(this.fileSystemUsageInGB, other.fileSystemUsageInGB) && Objects.equals(this.fileSystemAvailInPercent, other.fileSystemAvailInPercent) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mountPoint == null ? 43 : this.mountPoint.hashCode());
        result = result * 59 + (this.fileSystemUsageInGB == null ? 43 : this.fileSystemUsageInGB.hashCode());
        result = result * 59 + (this.fileSystemAvailInPercent == null ? 43 : this.fileSystemAvailInPercent.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="mountPoint")
        private String mountPoint;
        @JsonProperty(value="fileSystemUsageInGB")
        private Double fileSystemUsageInGB;
        @JsonProperty(value="fileSystemAvailInPercent")
        private Double fileSystemAvailInPercent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            this.__explicitlySet__.add("mountPoint");
            return this;
        }

        public Builder fileSystemUsageInGB(Double fileSystemUsageInGB) {
            this.fileSystemUsageInGB = fileSystemUsageInGB;
            this.__explicitlySet__.add("fileSystemUsageInGB");
            return this;
        }

        public Builder fileSystemAvailInPercent(Double fileSystemAvailInPercent) {
            this.fileSystemAvailInPercent = fileSystemAvailInPercent;
            this.__explicitlySet__.add("fileSystemAvailInPercent");
            return this;
        }

        public HostFilesystemUsage build() {
            HostFilesystemUsage model = new HostFilesystemUsage(this.timeCollected, this.mountPoint, this.fileSystemUsageInGB, this.fileSystemAvailInPercent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostFilesystemUsage model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("mountPoint")) {
                this.mountPoint(model.getMountPoint());
            }
            if (model.wasPropertyExplicitlySet("fileSystemUsageInGB")) {
                this.fileSystemUsageInGB(model.getFileSystemUsageInGB());
            }
            if (model.wasPropertyExplicitlySet("fileSystemAvailInPercent")) {
                this.fileSystemAvailInPercent(model.getFileSystemAvailInPercent());
            }
            return this;
        }
    }
}

