/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostResourceStatistics;
import com.oracle.bmc.opsi.model.SummaryStatistics;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resourceName")
@JsonFilter(value="explicitlySetFilter")
public final class HostMemoryStatistics
extends HostResourceStatistics {
    @JsonProperty(value="freeMemory")
    private final Double freeMemory;
    @JsonProperty(value="availableMemory")
    private final Double availableMemory;
    @JsonProperty(value="hugePagesTotal")
    private final Integer hugePagesTotal;
    @JsonProperty(value="hugePageSizeInMB")
    private final Double hugePageSizeInMB;
    @JsonProperty(value="hugePagesFree")
    private final Integer hugePagesFree;
    @JsonProperty(value="hugePagesReserved")
    private final Integer hugePagesReserved;
    @JsonProperty(value="load")
    private final SummaryStatistics load;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostMemoryStatistics(Double usage, Double capacity, Double utilizationPercent, Double usageChangePercent, Double freeMemory, Double availableMemory, Integer hugePagesTotal, Double hugePageSizeInMB, Integer hugePagesFree, Integer hugePagesReserved, SummaryStatistics load) {
        super(usage, capacity, utilizationPercent, usageChangePercent);
        this.freeMemory = freeMemory;
        this.availableMemory = availableMemory;
        this.hugePagesTotal = hugePagesTotal;
        this.hugePageSizeInMB = hugePageSizeInMB;
        this.hugePagesFree = hugePagesFree;
        this.hugePagesReserved = hugePagesReserved;
        this.load = load;
    }

    public Double getFreeMemory() {
        return this.freeMemory;
    }

    public Double getAvailableMemory() {
        return this.availableMemory;
    }

    public Integer getHugePagesTotal() {
        return this.hugePagesTotal;
    }

    public Double getHugePageSizeInMB() {
        return this.hugePageSizeInMB;
    }

    public Integer getHugePagesFree() {
        return this.hugePagesFree;
    }

    public Integer getHugePagesReserved() {
        return this.hugePagesReserved;
    }

    public SummaryStatistics getLoad() {
        return this.load;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostMemoryStatistics(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", freeMemory=").append(String.valueOf(this.freeMemory));
        sb.append(", availableMemory=").append(String.valueOf(this.availableMemory));
        sb.append(", hugePagesTotal=").append(String.valueOf(this.hugePagesTotal));
        sb.append(", hugePageSizeInMB=").append(String.valueOf(this.hugePageSizeInMB));
        sb.append(", hugePagesFree=").append(String.valueOf(this.hugePagesFree));
        sb.append(", hugePagesReserved=").append(String.valueOf(this.hugePagesReserved));
        sb.append(", load=").append(String.valueOf((Object)this.load));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostMemoryStatistics)) {
            return false;
        }
        HostMemoryStatistics other = (HostMemoryStatistics)((Object)o);
        return Objects.equals(this.freeMemory, other.freeMemory) && Objects.equals(this.availableMemory, other.availableMemory) && Objects.equals(this.hugePagesTotal, other.hugePagesTotal) && Objects.equals(this.hugePageSizeInMB, other.hugePageSizeInMB) && Objects.equals(this.hugePagesFree, other.hugePagesFree) && Objects.equals(this.hugePagesReserved, other.hugePagesReserved) && Objects.equals((Object)this.load, (Object)other.load) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.freeMemory == null ? 43 : this.freeMemory.hashCode());
        result = result * 59 + (this.availableMemory == null ? 43 : this.availableMemory.hashCode());
        result = result * 59 + (this.hugePagesTotal == null ? 43 : this.hugePagesTotal.hashCode());
        result = result * 59 + (this.hugePageSizeInMB == null ? 43 : this.hugePageSizeInMB.hashCode());
        result = result * 59 + (this.hugePagesFree == null ? 43 : this.hugePagesFree.hashCode());
        result = result * 59 + (this.hugePagesReserved == null ? 43 : this.hugePagesReserved.hashCode());
        result = result * 59 + (this.load == null ? 43 : this.load.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="usage")
        private Double usage;
        @JsonProperty(value="capacity")
        private Double capacity;
        @JsonProperty(value="utilizationPercent")
        private Double utilizationPercent;
        @JsonProperty(value="usageChangePercent")
        private Double usageChangePercent;
        @JsonProperty(value="freeMemory")
        private Double freeMemory;
        @JsonProperty(value="availableMemory")
        private Double availableMemory;
        @JsonProperty(value="hugePagesTotal")
        private Integer hugePagesTotal;
        @JsonProperty(value="hugePageSizeInMB")
        private Double hugePageSizeInMB;
        @JsonProperty(value="hugePagesFree")
        private Integer hugePagesFree;
        @JsonProperty(value="hugePagesReserved")
        private Integer hugePagesReserved;
        @JsonProperty(value="load")
        private SummaryStatistics load;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder usage(Double usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public Builder capacity(Double capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder utilizationPercent(Double utilizationPercent) {
            this.utilizationPercent = utilizationPercent;
            this.__explicitlySet__.add("utilizationPercent");
            return this;
        }

        public Builder usageChangePercent(Double usageChangePercent) {
            this.usageChangePercent = usageChangePercent;
            this.__explicitlySet__.add("usageChangePercent");
            return this;
        }

        public Builder freeMemory(Double freeMemory) {
            this.freeMemory = freeMemory;
            this.__explicitlySet__.add("freeMemory");
            return this;
        }

        public Builder availableMemory(Double availableMemory) {
            this.availableMemory = availableMemory;
            this.__explicitlySet__.add("availableMemory");
            return this;
        }

        public Builder hugePagesTotal(Integer hugePagesTotal) {
            this.hugePagesTotal = hugePagesTotal;
            this.__explicitlySet__.add("hugePagesTotal");
            return this;
        }

        public Builder hugePageSizeInMB(Double hugePageSizeInMB) {
            this.hugePageSizeInMB = hugePageSizeInMB;
            this.__explicitlySet__.add("hugePageSizeInMB");
            return this;
        }

        public Builder hugePagesFree(Integer hugePagesFree) {
            this.hugePagesFree = hugePagesFree;
            this.__explicitlySet__.add("hugePagesFree");
            return this;
        }

        public Builder hugePagesReserved(Integer hugePagesReserved) {
            this.hugePagesReserved = hugePagesReserved;
            this.__explicitlySet__.add("hugePagesReserved");
            return this;
        }

        public Builder load(SummaryStatistics load) {
            this.load = load;
            this.__explicitlySet__.add("load");
            return this;
        }

        public HostMemoryStatistics build() {
            HostMemoryStatistics model = new HostMemoryStatistics(this.usage, this.capacity, this.utilizationPercent, this.usageChangePercent, this.freeMemory, this.availableMemory, this.hugePagesTotal, this.hugePageSizeInMB, this.hugePagesFree, this.hugePagesReserved, this.load);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostMemoryStatistics model) {
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("utilizationPercent")) {
                this.utilizationPercent(model.getUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("usageChangePercent")) {
                this.usageChangePercent(model.getUsageChangePercent());
            }
            if (model.wasPropertyExplicitlySet("freeMemory")) {
                this.freeMemory(model.getFreeMemory());
            }
            if (model.wasPropertyExplicitlySet("availableMemory")) {
                this.availableMemory(model.getAvailableMemory());
            }
            if (model.wasPropertyExplicitlySet("hugePagesTotal")) {
                this.hugePagesTotal(model.getHugePagesTotal());
            }
            if (model.wasPropertyExplicitlySet("hugePageSizeInMB")) {
                this.hugePageSizeInMB(model.getHugePageSizeInMB());
            }
            if (model.wasPropertyExplicitlySet("hugePagesFree")) {
                this.hugePagesFree(model.getHugePagesFree());
            }
            if (model.wasPropertyExplicitlySet("hugePagesReserved")) {
                this.hugePagesReserved(model.getHugePagesReserved());
            }
            if (model.wasPropertyExplicitlySet("load")) {
                this.load(model.getLoad());
            }
            return this;
        }
    }
}

