/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="instanceName")
    private final String instanceName;
    @JsonProperty(value="usage")
    private final Double usage;
    @JsonProperty(value="capacity")
    private final Double capacity;
    @JsonProperty(value="totalHostCapacity")
    private final Double totalHostCapacity;
    @JsonProperty(value="utilizationPercent")
    private final Double utilizationPercent;
    @JsonProperty(value="usageChangePercent")
    private final Double usageChangePercent;

    @Deprecated
    @ConstructorProperties(value={"hostName", "instanceName", "usage", "capacity", "totalHostCapacity", "utilizationPercent", "usageChangePercent"})
    public InstanceMetrics(String hostName, String instanceName, Double usage, Double capacity, Double totalHostCapacity, Double utilizationPercent, Double usageChangePercent) {
        this.hostName = hostName;
        this.instanceName = instanceName;
        this.usage = usage;
        this.capacity = capacity;
        this.totalHostCapacity = totalHostCapacity;
        this.utilizationPercent = utilizationPercent;
        this.usageChangePercent = usageChangePercent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Double getUsage() {
        return this.usage;
    }

    public Double getCapacity() {
        return this.capacity;
    }

    public Double getTotalHostCapacity() {
        return this.totalHostCapacity;
    }

    public Double getUtilizationPercent() {
        return this.utilizationPercent;
    }

    public Double getUsageChangePercent() {
        return this.usageChangePercent;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("hostName=").append(String.valueOf(this.hostName));
        sb.append(", instanceName=").append(String.valueOf(this.instanceName));
        sb.append(", usage=").append(String.valueOf(this.usage));
        sb.append(", capacity=").append(String.valueOf(this.capacity));
        sb.append(", totalHostCapacity=").append(String.valueOf(this.totalHostCapacity));
        sb.append(", utilizationPercent=").append(String.valueOf(this.utilizationPercent));
        sb.append(", usageChangePercent=").append(String.valueOf(this.usageChangePercent));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceMetrics)) {
            return false;
        }
        InstanceMetrics other = (InstanceMetrics)((Object)o);
        return Objects.equals(this.hostName, other.hostName) && Objects.equals(this.instanceName, other.instanceName) && Objects.equals(this.usage, other.usage) && Objects.equals(this.capacity, other.capacity) && Objects.equals(this.totalHostCapacity, other.totalHostCapacity) && Objects.equals(this.utilizationPercent, other.utilizationPercent) && Objects.equals(this.usageChangePercent, other.usageChangePercent) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.instanceName == null ? 43 : this.instanceName.hashCode());
        result = result * 59 + (this.usage == null ? 43 : this.usage.hashCode());
        result = result * 59 + (this.capacity == null ? 43 : this.capacity.hashCode());
        result = result * 59 + (this.totalHostCapacity == null ? 43 : this.totalHostCapacity.hashCode());
        result = result * 59 + (this.utilizationPercent == null ? 43 : this.utilizationPercent.hashCode());
        result = result * 59 + (this.usageChangePercent == null ? 43 : this.usageChangePercent.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="usage")
        private Double usage;
        @JsonProperty(value="capacity")
        private Double capacity;
        @JsonProperty(value="totalHostCapacity")
        private Double totalHostCapacity;
        @JsonProperty(value="utilizationPercent")
        private Double utilizationPercent;
        @JsonProperty(value="usageChangePercent")
        private Double usageChangePercent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            this.__explicitlySet__.add("instanceName");
            return this;
        }

        public Builder usage(Double usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public Builder capacity(Double capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder totalHostCapacity(Double totalHostCapacity) {
            this.totalHostCapacity = totalHostCapacity;
            this.__explicitlySet__.add("totalHostCapacity");
            return this;
        }

        public Builder utilizationPercent(Double utilizationPercent) {
            this.utilizationPercent = utilizationPercent;
            this.__explicitlySet__.add("utilizationPercent");
            return this;
        }

        public Builder usageChangePercent(Double usageChangePercent) {
            this.usageChangePercent = usageChangePercent;
            this.__explicitlySet__.add("usageChangePercent");
            return this;
        }

        public InstanceMetrics build() {
            InstanceMetrics model = new InstanceMetrics(this.hostName, this.instanceName, this.usage, this.capacity, this.totalHostCapacity, this.utilizationPercent, this.usageChangePercent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceMetrics model) {
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("instanceName")) {
                this.instanceName(model.getInstanceName());
            }
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("totalHostCapacity")) {
                this.totalHostCapacity(model.getTotalHostCapacity());
            }
            if (model.wasPropertyExplicitlySet("utilizationPercent")) {
                this.utilizationPercent(model.getUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("usageChangePercent")) {
                this.usageChangePercent(model.getUsageChangePercent());
            }
            return this;
        }
    }
}

