/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.NetworkUsageTrend;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NetworkUsageTrendAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="interfaceName")
    private final String interfaceName;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="macAddress")
    private final String macAddress;
    @JsonProperty(value="usageData")
    private final List<NetworkUsageTrend> usageData;

    @Deprecated
    @ConstructorProperties(value={"interfaceName", "ipAddress", "macAddress", "usageData"})
    public NetworkUsageTrendAggregation(String interfaceName, String ipAddress, String macAddress, List<NetworkUsageTrend> usageData) {
        this.interfaceName = interfaceName;
        this.ipAddress = ipAddress;
        this.macAddress = macAddress;
        this.usageData = usageData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public List<NetworkUsageTrend> getUsageData() {
        return this.usageData;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkUsageTrendAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("interfaceName=").append(String.valueOf(this.interfaceName));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", macAddress=").append(String.valueOf(this.macAddress));
        sb.append(", usageData=").append(String.valueOf(this.usageData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkUsageTrendAggregation)) {
            return false;
        }
        NetworkUsageTrendAggregation other = (NetworkUsageTrendAggregation)((Object)o);
        return Objects.equals(this.interfaceName, other.interfaceName) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.macAddress, other.macAddress) && Objects.equals(this.usageData, other.usageData) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.interfaceName == null ? 43 : this.interfaceName.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.macAddress == null ? 43 : this.macAddress.hashCode());
        result = result * 59 + (this.usageData == null ? 43 : this.usageData.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="interfaceName")
        private String interfaceName;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="macAddress")
        private String macAddress;
        @JsonProperty(value="usageData")
        private List<NetworkUsageTrend> usageData;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder interfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
            this.__explicitlySet__.add("interfaceName");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            this.__explicitlySet__.add("macAddress");
            return this;
        }

        public Builder usageData(List<NetworkUsageTrend> usageData) {
            this.usageData = usageData;
            this.__explicitlySet__.add("usageData");
            return this;
        }

        public NetworkUsageTrendAggregation build() {
            NetworkUsageTrendAggregation model = new NetworkUsageTrendAggregation(this.interfaceName, this.ipAddress, this.macAddress, this.usageData);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NetworkUsageTrendAggregation model) {
            if (model.wasPropertyExplicitlySet("interfaceName")) {
                this.interfaceName(model.getInterfaceName());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("macAddress")) {
                this.macAddress(model.getMacAddress());
            }
            if (model.wasPropertyExplicitlySet("usageData")) {
                this.usageData(model.getUsageData());
            }
            return this;
        }
    }
}

