/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlBucket
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final Float version;
    @JsonProperty(value="databaseType")
    private final String databaseType;
    @JsonProperty(value="timeCollected")
    private final Date timeCollected;
    @JsonProperty(value="sqlIdentifier")
    private final String sqlIdentifier;
    @JsonProperty(value="planHash")
    private final Long planHash;
    @JsonProperty(value="bucketId")
    private final String bucketId;
    @JsonProperty(value="executionsCount")
    private final Integer executionsCount;
    @JsonProperty(value="cpuTimeInSec")
    private final Float cpuTimeInSec;
    @JsonProperty(value="ioTimeInSec")
    private final Float ioTimeInSec;
    @JsonProperty(value="otherWaitTimeInSec")
    private final Float otherWaitTimeInSec;
    @JsonProperty(value="totalTimeInSec")
    private final Float totalTimeInSec;

    @Deprecated
    @ConstructorProperties(value={"version", "databaseType", "timeCollected", "sqlIdentifier", "planHash", "bucketId", "executionsCount", "cpuTimeInSec", "ioTimeInSec", "otherWaitTimeInSec", "totalTimeInSec"})
    public SqlBucket(Float version, String databaseType, Date timeCollected, String sqlIdentifier, Long planHash, String bucketId, Integer executionsCount, Float cpuTimeInSec, Float ioTimeInSec, Float otherWaitTimeInSec, Float totalTimeInSec) {
        this.version = version;
        this.databaseType = databaseType;
        this.timeCollected = timeCollected;
        this.sqlIdentifier = sqlIdentifier;
        this.planHash = planHash;
        this.bucketId = bucketId;
        this.executionsCount = executionsCount;
        this.cpuTimeInSec = cpuTimeInSec;
        this.ioTimeInSec = ioTimeInSec;
        this.otherWaitTimeInSec = otherWaitTimeInSec;
        this.totalTimeInSec = totalTimeInSec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getVersion() {
        return this.version;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Date getTimeCollected() {
        return this.timeCollected;
    }

    public String getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public Long getPlanHash() {
        return this.planHash;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public Integer getExecutionsCount() {
        return this.executionsCount;
    }

    public Float getCpuTimeInSec() {
        return this.cpuTimeInSec;
    }

    public Float getIoTimeInSec() {
        return this.ioTimeInSec;
    }

    public Float getOtherWaitTimeInSec() {
        return this.otherWaitTimeInSec;
    }

    public Float getTotalTimeInSec() {
        return this.totalTimeInSec;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlBucket(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", databaseType=").append(String.valueOf(this.databaseType));
        sb.append(", timeCollected=").append(String.valueOf(this.timeCollected));
        sb.append(", sqlIdentifier=").append(String.valueOf(this.sqlIdentifier));
        sb.append(", planHash=").append(String.valueOf(this.planHash));
        sb.append(", bucketId=").append(String.valueOf(this.bucketId));
        sb.append(", executionsCount=").append(String.valueOf(this.executionsCount));
        sb.append(", cpuTimeInSec=").append(String.valueOf(this.cpuTimeInSec));
        sb.append(", ioTimeInSec=").append(String.valueOf(this.ioTimeInSec));
        sb.append(", otherWaitTimeInSec=").append(String.valueOf(this.otherWaitTimeInSec));
        sb.append(", totalTimeInSec=").append(String.valueOf(this.totalTimeInSec));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlBucket)) {
            return false;
        }
        SqlBucket other = (SqlBucket)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.databaseType, other.databaseType) && Objects.equals(this.timeCollected, other.timeCollected) && Objects.equals(this.sqlIdentifier, other.sqlIdentifier) && Objects.equals(this.planHash, other.planHash) && Objects.equals(this.bucketId, other.bucketId) && Objects.equals(this.executionsCount, other.executionsCount) && Objects.equals(this.cpuTimeInSec, other.cpuTimeInSec) && Objects.equals(this.ioTimeInSec, other.ioTimeInSec) && Objects.equals(this.otherWaitTimeInSec, other.otherWaitTimeInSec) && Objects.equals(this.totalTimeInSec, other.totalTimeInSec) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.timeCollected == null ? 43 : this.timeCollected.hashCode());
        result = result * 59 + (this.sqlIdentifier == null ? 43 : this.sqlIdentifier.hashCode());
        result = result * 59 + (this.planHash == null ? 43 : this.planHash.hashCode());
        result = result * 59 + (this.bucketId == null ? 43 : this.bucketId.hashCode());
        result = result * 59 + (this.executionsCount == null ? 43 : this.executionsCount.hashCode());
        result = result * 59 + (this.cpuTimeInSec == null ? 43 : this.cpuTimeInSec.hashCode());
        result = result * 59 + (this.ioTimeInSec == null ? 43 : this.ioTimeInSec.hashCode());
        result = result * 59 + (this.otherWaitTimeInSec == null ? 43 : this.otherWaitTimeInSec.hashCode());
        result = result * 59 + (this.totalTimeInSec == null ? 43 : this.totalTimeInSec.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private Float version;
        @JsonProperty(value="databaseType")
        private String databaseType;
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="sqlIdentifier")
        private String sqlIdentifier;
        @JsonProperty(value="planHash")
        private Long planHash;
        @JsonProperty(value="bucketId")
        private String bucketId;
        @JsonProperty(value="executionsCount")
        private Integer executionsCount;
        @JsonProperty(value="cpuTimeInSec")
        private Float cpuTimeInSec;
        @JsonProperty(value="ioTimeInSec")
        private Float ioTimeInSec;
        @JsonProperty(value="otherWaitTimeInSec")
        private Float otherWaitTimeInSec;
        @JsonProperty(value="totalTimeInSec")
        private Float totalTimeInSec;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(Float version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder databaseType(String databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder sqlIdentifier(String sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            this.__explicitlySet__.add("sqlIdentifier");
            return this;
        }

        public Builder planHash(Long planHash) {
            this.planHash = planHash;
            this.__explicitlySet__.add("planHash");
            return this;
        }

        public Builder bucketId(String bucketId) {
            this.bucketId = bucketId;
            this.__explicitlySet__.add("bucketId");
            return this;
        }

        public Builder executionsCount(Integer executionsCount) {
            this.executionsCount = executionsCount;
            this.__explicitlySet__.add("executionsCount");
            return this;
        }

        public Builder cpuTimeInSec(Float cpuTimeInSec) {
            this.cpuTimeInSec = cpuTimeInSec;
            this.__explicitlySet__.add("cpuTimeInSec");
            return this;
        }

        public Builder ioTimeInSec(Float ioTimeInSec) {
            this.ioTimeInSec = ioTimeInSec;
            this.__explicitlySet__.add("ioTimeInSec");
            return this;
        }

        public Builder otherWaitTimeInSec(Float otherWaitTimeInSec) {
            this.otherWaitTimeInSec = otherWaitTimeInSec;
            this.__explicitlySet__.add("otherWaitTimeInSec");
            return this;
        }

        public Builder totalTimeInSec(Float totalTimeInSec) {
            this.totalTimeInSec = totalTimeInSec;
            this.__explicitlySet__.add("totalTimeInSec");
            return this;
        }

        public SqlBucket build() {
            SqlBucket model = new SqlBucket(this.version, this.databaseType, this.timeCollected, this.sqlIdentifier, this.planHash, this.bucketId, this.executionsCount, this.cpuTimeInSec, this.ioTimeInSec, this.otherWaitTimeInSec, this.totalTimeInSec);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlBucket model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("sqlIdentifier")) {
                this.sqlIdentifier(model.getSqlIdentifier());
            }
            if (model.wasPropertyExplicitlySet("planHash")) {
                this.planHash(model.getPlanHash());
            }
            if (model.wasPropertyExplicitlySet("bucketId")) {
                this.bucketId(model.getBucketId());
            }
            if (model.wasPropertyExplicitlySet("executionsCount")) {
                this.executionsCount(model.getExecutionsCount());
            }
            if (model.wasPropertyExplicitlySet("cpuTimeInSec")) {
                this.cpuTimeInSec(model.getCpuTimeInSec());
            }
            if (model.wasPropertyExplicitlySet("ioTimeInSec")) {
                this.ioTimeInSec(model.getIoTimeInSec());
            }
            if (model.wasPropertyExplicitlySet("otherWaitTimeInSec")) {
                this.otherWaitTimeInSec(model.getOtherWaitTimeInSec());
            }
            if (model.wasPropertyExplicitlySet("totalTimeInSec")) {
                this.totalTimeInSec(model.getTotalTimeInSec());
            }
            return this;
        }
    }
}

