/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.SqlSearchSummary;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlSearchCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sqlIdentifier")
    private final String sqlIdentifier;
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="timeIntervalStart")
    private final Date timeIntervalStart;
    @JsonProperty(value="timeIntervalEnd")
    private final Date timeIntervalEnd;
    @JsonProperty(value="items")
    private final List<SqlSearchSummary> items;

    @Deprecated
    @ConstructorProperties(value={"sqlIdentifier", "sqlText", "timeIntervalStart", "timeIntervalEnd", "items"})
    public SqlSearchCollection(String sqlIdentifier, String sqlText, Date timeIntervalStart, Date timeIntervalEnd, List<SqlSearchSummary> items) {
        this.sqlIdentifier = sqlIdentifier;
        this.sqlText = sqlText;
        this.timeIntervalStart = timeIntervalStart;
        this.timeIntervalEnd = timeIntervalEnd;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public List<SqlSearchSummary> getItems() {
        return this.items;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlSearchCollection(");
        sb.append("super=").append(super.toString());
        sb.append("sqlIdentifier=").append(String.valueOf(this.sqlIdentifier));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(", timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(", timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlSearchCollection)) {
            return false;
        }
        SqlSearchCollection other = (SqlSearchCollection)((Object)o);
        return Objects.equals(this.sqlIdentifier, other.sqlIdentifier) && Objects.equals(this.sqlText, other.sqlText) && Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.items, other.items) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sqlIdentifier == null ? 43 : this.sqlIdentifier.hashCode());
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sqlIdentifier")
        private String sqlIdentifier;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="timeIntervalStart")
        private Date timeIntervalStart;
        @JsonProperty(value="timeIntervalEnd")
        private Date timeIntervalEnd;
        @JsonProperty(value="items")
        private List<SqlSearchSummary> items;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sqlIdentifier(String sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            this.__explicitlySet__.add("sqlIdentifier");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            this.__explicitlySet__.add("timeIntervalStart");
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            this.__explicitlySet__.add("timeIntervalEnd");
            return this;
        }

        public Builder items(List<SqlSearchSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public SqlSearchCollection build() {
            SqlSearchCollection model = new SqlSearchCollection(this.sqlIdentifier, this.sqlText, this.timeIntervalStart, this.timeIntervalEnd, this.items);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlSearchCollection model) {
            if (model.wasPropertyExplicitlySet("sqlIdentifier")) {
                this.sqlIdentifier(model.getSqlIdentifier());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            if (model.wasPropertyExplicitlySet("timeIntervalStart")) {
                this.timeIntervalStart(model.getTimeIntervalStart());
            }
            if (model.wasPropertyExplicitlySet("timeIntervalEnd")) {
                this.timeIntervalEnd(model.getTimeIntervalEnd());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            return this;
        }
    }
}

