/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StorageUsageTrend
extends ExplicitlySetBmcModel {
    @JsonProperty(value="endTimestamp")
    private final Date endTimestamp;
    @JsonProperty(value="fileSystemUsageInGBs")
    private final Double fileSystemUsageInGBs;
    @JsonProperty(value="fileSystemAvailInPercent")
    private final Double fileSystemAvailInPercent;

    @Deprecated
    @ConstructorProperties(value={"endTimestamp", "fileSystemUsageInGBs", "fileSystemAvailInPercent"})
    public StorageUsageTrend(Date endTimestamp, Double fileSystemUsageInGBs, Double fileSystemAvailInPercent) {
        this.endTimestamp = endTimestamp;
        this.fileSystemUsageInGBs = fileSystemUsageInGBs;
        this.fileSystemAvailInPercent = fileSystemAvailInPercent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public Double getFileSystemUsageInGBs() {
        return this.fileSystemUsageInGBs;
    }

    public Double getFileSystemAvailInPercent() {
        return this.fileSystemAvailInPercent;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StorageUsageTrend(");
        sb.append("super=").append(super.toString());
        sb.append("endTimestamp=").append(String.valueOf(this.endTimestamp));
        sb.append(", fileSystemUsageInGBs=").append(String.valueOf(this.fileSystemUsageInGBs));
        sb.append(", fileSystemAvailInPercent=").append(String.valueOf(this.fileSystemAvailInPercent));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageUsageTrend)) {
            return false;
        }
        StorageUsageTrend other = (StorageUsageTrend)((Object)o);
        return Objects.equals(this.endTimestamp, other.endTimestamp) && Objects.equals(this.fileSystemUsageInGBs, other.fileSystemUsageInGBs) && Objects.equals(this.fileSystemAvailInPercent, other.fileSystemAvailInPercent) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.endTimestamp == null ? 43 : this.endTimestamp.hashCode());
        result = result * 59 + (this.fileSystemUsageInGBs == null ? 43 : this.fileSystemUsageInGBs.hashCode());
        result = result * 59 + (this.fileSystemAvailInPercent == null ? 43 : this.fileSystemAvailInPercent.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="endTimestamp")
        private Date endTimestamp;
        @JsonProperty(value="fileSystemUsageInGBs")
        private Double fileSystemUsageInGBs;
        @JsonProperty(value="fileSystemAvailInPercent")
        private Double fileSystemAvailInPercent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder endTimestamp(Date endTimestamp) {
            this.endTimestamp = endTimestamp;
            this.__explicitlySet__.add("endTimestamp");
            return this;
        }

        public Builder fileSystemUsageInGBs(Double fileSystemUsageInGBs) {
            this.fileSystemUsageInGBs = fileSystemUsageInGBs;
            this.__explicitlySet__.add("fileSystemUsageInGBs");
            return this;
        }

        public Builder fileSystemAvailInPercent(Double fileSystemAvailInPercent) {
            this.fileSystemAvailInPercent = fileSystemAvailInPercent;
            this.__explicitlySet__.add("fileSystemAvailInPercent");
            return this;
        }

        public StorageUsageTrend build() {
            StorageUsageTrend model = new StorageUsageTrend(this.endTimestamp, this.fileSystemUsageInGBs, this.fileSystemAvailInPercent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StorageUsageTrend model) {
            if (model.wasPropertyExplicitlySet("endTimestamp")) {
                this.endTimestamp(model.getEndTimestamp());
            }
            if (model.wasPropertyExplicitlySet("fileSystemUsageInGBs")) {
                this.fileSystemUsageInGBs(model.getFileSystemUsageInGBs());
            }
            if (model.wasPropertyExplicitlySet("fileSystemAvailInPercent")) {
                this.fileSystemAvailInPercent(model.getFileSystemAvailInPercent());
            }
            return this;
        }
    }
}

