/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.StorageUsageTrend;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StorageUsageTrendAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fileSystemName")
    private final String fileSystemName;
    @JsonProperty(value="mountPoint")
    private final String mountPoint;
    @JsonProperty(value="fileSystemSizeInGBs")
    private final Double fileSystemSizeInGBs;
    @JsonProperty(value="usageData")
    private final List<StorageUsageTrend> usageData;

    @Deprecated
    @ConstructorProperties(value={"fileSystemName", "mountPoint", "fileSystemSizeInGBs", "usageData"})
    public StorageUsageTrendAggregation(String fileSystemName, String mountPoint, Double fileSystemSizeInGBs, List<StorageUsageTrend> usageData) {
        this.fileSystemName = fileSystemName;
        this.mountPoint = mountPoint;
        this.fileSystemSizeInGBs = fileSystemSizeInGBs;
        this.usageData = usageData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public Double getFileSystemSizeInGBs() {
        return this.fileSystemSizeInGBs;
    }

    public List<StorageUsageTrend> getUsageData() {
        return this.usageData;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StorageUsageTrendAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("fileSystemName=").append(String.valueOf(this.fileSystemName));
        sb.append(", mountPoint=").append(String.valueOf(this.mountPoint));
        sb.append(", fileSystemSizeInGBs=").append(String.valueOf(this.fileSystemSizeInGBs));
        sb.append(", usageData=").append(String.valueOf(this.usageData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageUsageTrendAggregation)) {
            return false;
        }
        StorageUsageTrendAggregation other = (StorageUsageTrendAggregation)((Object)o);
        return Objects.equals(this.fileSystemName, other.fileSystemName) && Objects.equals(this.mountPoint, other.mountPoint) && Objects.equals(this.fileSystemSizeInGBs, other.fileSystemSizeInGBs) && Objects.equals(this.usageData, other.usageData) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fileSystemName == null ? 43 : this.fileSystemName.hashCode());
        result = result * 59 + (this.mountPoint == null ? 43 : this.mountPoint.hashCode());
        result = result * 59 + (this.fileSystemSizeInGBs == null ? 43 : this.fileSystemSizeInGBs.hashCode());
        result = result * 59 + (this.usageData == null ? 43 : this.usageData.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fileSystemName")
        private String fileSystemName;
        @JsonProperty(value="mountPoint")
        private String mountPoint;
        @JsonProperty(value="fileSystemSizeInGBs")
        private Double fileSystemSizeInGBs;
        @JsonProperty(value="usageData")
        private List<StorageUsageTrend> usageData;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fileSystemName(String fileSystemName) {
            this.fileSystemName = fileSystemName;
            this.__explicitlySet__.add("fileSystemName");
            return this;
        }

        public Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            this.__explicitlySet__.add("mountPoint");
            return this;
        }

        public Builder fileSystemSizeInGBs(Double fileSystemSizeInGBs) {
            this.fileSystemSizeInGBs = fileSystemSizeInGBs;
            this.__explicitlySet__.add("fileSystemSizeInGBs");
            return this;
        }

        public Builder usageData(List<StorageUsageTrend> usageData) {
            this.usageData = usageData;
            this.__explicitlySet__.add("usageData");
            return this;
        }

        public StorageUsageTrendAggregation build() {
            StorageUsageTrendAggregation model = new StorageUsageTrendAggregation(this.fileSystemName, this.mountPoint, this.fileSystemSizeInGBs, this.usageData);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StorageUsageTrendAggregation model) {
            if (model.wasPropertyExplicitlySet("fileSystemName")) {
                this.fileSystemName(model.getFileSystemName());
            }
            if (model.wasPropertyExplicitlySet("mountPoint")) {
                this.mountPoint(model.getMountPoint());
            }
            if (model.wasPropertyExplicitlySet("fileSystemSizeInGBs")) {
                this.fileSystemSizeInGBs(model.getFileSystemSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("usageData")) {
                this.usageData(model.getUsageData());
            }
            return this;
        }
    }
}

