/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetAwrDatabaseSqlReportRequest
extends BmcRequest<Void> {
    private String awrHubId;
    private String awrSourceDatabaseIdentifier;
    private String sqlId;
    private String instanceNumber;
    private Integer beginSnapshotIdentifierGreaterThanOrEqualTo;
    private Integer endSnapshotIdentifierLessThanOrEqualTo;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private ReportFormat reportFormat;
    private String opcRequestId;

    public String getAwrHubId() {
        return this.awrHubId;
    }

    public String getAwrSourceDatabaseIdentifier() {
        return this.awrSourceDatabaseIdentifier;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public Integer getBeginSnapshotIdentifierGreaterThanOrEqualTo() {
        return this.beginSnapshotIdentifierGreaterThanOrEqualTo;
    }

    public Integer getEndSnapshotIdentifierLessThanOrEqualTo() {
        return this.endSnapshotIdentifierLessThanOrEqualTo;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().awrHubId(this.awrHubId).awrSourceDatabaseIdentifier(this.awrSourceDatabaseIdentifier).sqlId(this.sqlId).instanceNumber(this.instanceNumber).beginSnapshotIdentifierGreaterThanOrEqualTo(this.beginSnapshotIdentifierGreaterThanOrEqualTo).endSnapshotIdentifierLessThanOrEqualTo(this.endSnapshotIdentifierLessThanOrEqualTo).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).reportFormat(this.reportFormat).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",awrHubId=").append(String.valueOf(this.awrHubId));
        sb.append(",awrSourceDatabaseIdentifier=").append(String.valueOf(this.awrSourceDatabaseIdentifier));
        sb.append(",sqlId=").append(String.valueOf(this.sqlId));
        sb.append(",instanceNumber=").append(String.valueOf(this.instanceNumber));
        sb.append(",beginSnapshotIdentifierGreaterThanOrEqualTo=").append(String.valueOf(this.beginSnapshotIdentifierGreaterThanOrEqualTo));
        sb.append(",endSnapshotIdentifierLessThanOrEqualTo=").append(String.valueOf(this.endSnapshotIdentifierLessThanOrEqualTo));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",reportFormat=").append(String.valueOf((Object)this.reportFormat));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAwrDatabaseSqlReportRequest)) {
            return false;
        }
        GetAwrDatabaseSqlReportRequest other = (GetAwrDatabaseSqlReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.awrHubId, other.awrHubId) && Objects.equals(this.awrSourceDatabaseIdentifier, other.awrSourceDatabaseIdentifier) && Objects.equals(this.sqlId, other.sqlId) && Objects.equals(this.instanceNumber, other.instanceNumber) && Objects.equals(this.beginSnapshotIdentifierGreaterThanOrEqualTo, other.beginSnapshotIdentifierGreaterThanOrEqualTo) && Objects.equals(this.endSnapshotIdentifierLessThanOrEqualTo, other.endSnapshotIdentifierLessThanOrEqualTo) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals((Object)this.reportFormat, (Object)other.reportFormat) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.awrHubId == null ? 43 : this.awrHubId.hashCode());
        result = result * 59 + (this.awrSourceDatabaseIdentifier == null ? 43 : this.awrSourceDatabaseIdentifier.hashCode());
        result = result * 59 + (this.sqlId == null ? 43 : this.sqlId.hashCode());
        result = result * 59 + (this.instanceNumber == null ? 43 : this.instanceNumber.hashCode());
        result = result * 59 + (this.beginSnapshotIdentifierGreaterThanOrEqualTo == null ? 43 : this.beginSnapshotIdentifierGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.endSnapshotIdentifierLessThanOrEqualTo == null ? 43 : this.endSnapshotIdentifierLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.reportFormat == null ? 43 : this.reportFormat.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAwrDatabaseSqlReportRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String awrHubId = null;
        private String awrSourceDatabaseIdentifier = null;
        private String sqlId = null;
        private String instanceNumber = null;
        private Integer beginSnapshotIdentifierGreaterThanOrEqualTo = null;
        private Integer endSnapshotIdentifierLessThanOrEqualTo = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private ReportFormat reportFormat = null;
        private String opcRequestId = null;

        public Builder awrHubId(String awrHubId) {
            this.awrHubId = awrHubId;
            return this;
        }

        public Builder awrSourceDatabaseIdentifier(String awrSourceDatabaseIdentifier) {
            this.awrSourceDatabaseIdentifier = awrSourceDatabaseIdentifier;
            return this;
        }

        public Builder sqlId(String sqlId) {
            this.sqlId = sqlId;
            return this;
        }

        public Builder instanceNumber(String instanceNumber) {
            this.instanceNumber = instanceNumber;
            return this;
        }

        public Builder beginSnapshotIdentifierGreaterThanOrEqualTo(Integer beginSnapshotIdentifierGreaterThanOrEqualTo) {
            this.beginSnapshotIdentifierGreaterThanOrEqualTo = beginSnapshotIdentifierGreaterThanOrEqualTo;
            return this;
        }

        public Builder endSnapshotIdentifierLessThanOrEqualTo(Integer endSnapshotIdentifierLessThanOrEqualTo) {
            this.endSnapshotIdentifierLessThanOrEqualTo = endSnapshotIdentifierLessThanOrEqualTo;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder reportFormat(ReportFormat reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAwrDatabaseSqlReportRequest o) {
            this.awrHubId(o.getAwrHubId());
            this.awrSourceDatabaseIdentifier(o.getAwrSourceDatabaseIdentifier());
            this.sqlId(o.getSqlId());
            this.instanceNumber(o.getInstanceNumber());
            this.beginSnapshotIdentifierGreaterThanOrEqualTo(o.getBeginSnapshotIdentifierGreaterThanOrEqualTo());
            this.endSnapshotIdentifierLessThanOrEqualTo(o.getEndSnapshotIdentifierLessThanOrEqualTo());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.reportFormat(o.getReportFormat());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAwrDatabaseSqlReportRequest build() {
            GetAwrDatabaseSqlReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAwrDatabaseSqlReportRequest buildWithoutInvocationCallback() {
            GetAwrDatabaseSqlReportRequest request = new GetAwrDatabaseSqlReportRequest();
            request.awrHubId = this.awrHubId;
            request.awrSourceDatabaseIdentifier = this.awrSourceDatabaseIdentifier;
            request.sqlId = this.sqlId;
            request.instanceNumber = this.instanceNumber;
            request.beginSnapshotIdentifierGreaterThanOrEqualTo = this.beginSnapshotIdentifierGreaterThanOrEqualTo;
            request.endSnapshotIdentifierLessThanOrEqualTo = this.endSnapshotIdentifierLessThanOrEqualTo;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.reportFormat = this.reportFormat;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum ReportFormat implements BmcEnum
    {
        Html("HTML"),
        Text("TEXT");

        private final String value;
        private static Map<String, ReportFormat> map;

        private ReportFormat(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReportFormat create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReportFormat: " + key);
        }

        static {
            map = new HashMap<String, ReportFormat>();
            for (ReportFormat v : ReportFormat.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

