/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.opsi.model.NewsContentTypes;
import com.oracle.bmc.opsi.model.NewsFrequency;
import com.oracle.bmc.opsi.model.NewsLocale;
import com.oracle.bmc.opsi.model.ResourceStatus;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateNewsReportDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="newsFrequency")
    private final NewsFrequency newsFrequency;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="onsTopicId")
    private final String onsTopicId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="contentTypes")
    private final NewsContentTypes contentTypes;
    @JsonProperty(value="locale")
    private final NewsLocale locale;
    @JsonProperty(value="status")
    private final ResourceStatus status;

    @Deprecated
    @ConstructorProperties(value={"name", "newsFrequency", "description", "onsTopicId", "compartmentId", "freeformTags", "definedTags", "contentTypes", "locale", "status"})
    public CreateNewsReportDetails(String name, NewsFrequency newsFrequency, String description, String onsTopicId, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, NewsContentTypes contentTypes, NewsLocale locale, ResourceStatus status) {
        this.name = name;
        this.newsFrequency = newsFrequency;
        this.description = description;
        this.onsTopicId = onsTopicId;
        this.compartmentId = compartmentId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.contentTypes = contentTypes;
        this.locale = locale;
        this.status = status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public NewsFrequency getNewsFrequency() {
        return this.newsFrequency;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOnsTopicId() {
        return this.onsTopicId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public NewsContentTypes getContentTypes() {
        return this.contentTypes;
    }

    public NewsLocale getLocale() {
        return this.locale;
    }

    public ResourceStatus getStatus() {
        return this.status;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateNewsReportDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", newsFrequency=").append(String.valueOf((Object)this.newsFrequency));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", onsTopicId=").append(String.valueOf(this.onsTopicId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", contentTypes=").append(String.valueOf((Object)this.contentTypes));
        sb.append(", locale=").append(String.valueOf((Object)this.locale));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateNewsReportDetails)) {
            return false;
        }
        CreateNewsReportDetails other = (CreateNewsReportDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.newsFrequency, (Object)other.newsFrequency) && Objects.equals(this.description, other.description) && Objects.equals(this.onsTopicId, other.onsTopicId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.contentTypes, (Object)other.contentTypes) && Objects.equals((Object)this.locale, (Object)other.locale) && Objects.equals((Object)this.status, (Object)other.status) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.newsFrequency == null ? 43 : this.newsFrequency.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.onsTopicId == null ? 43 : this.onsTopicId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.contentTypes == null ? 43 : this.contentTypes.hashCode());
        result = result * 59 + (this.locale == null ? 43 : this.locale.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="newsFrequency")
        private NewsFrequency newsFrequency;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="onsTopicId")
        private String onsTopicId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="contentTypes")
        private NewsContentTypes contentTypes;
        @JsonProperty(value="locale")
        private NewsLocale locale;
        @JsonProperty(value="status")
        private ResourceStatus status;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder newsFrequency(NewsFrequency newsFrequency) {
            this.newsFrequency = newsFrequency;
            this.__explicitlySet__.add("newsFrequency");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder onsTopicId(String onsTopicId) {
            this.onsTopicId = onsTopicId;
            this.__explicitlySet__.add("onsTopicId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder contentTypes(NewsContentTypes contentTypes) {
            this.contentTypes = contentTypes;
            this.__explicitlySet__.add("contentTypes");
            return this;
        }

        public Builder locale(NewsLocale locale) {
            this.locale = locale;
            this.__explicitlySet__.add("locale");
            return this;
        }

        public Builder status(ResourceStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public CreateNewsReportDetails build() {
            CreateNewsReportDetails model = new CreateNewsReportDetails(this.name, this.newsFrequency, this.description, this.onsTopicId, this.compartmentId, this.freeformTags, this.definedTags, this.contentTypes, this.locale, this.status);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateNewsReportDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("newsFrequency")) {
                this.newsFrequency(model.getNewsFrequency());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("onsTopicId")) {
                this.onsTopicId(model.getOnsTopicId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("contentTypes")) {
                this.contentTypes(model.getContentTypes());
            }
            if (model.wasPropertyExplicitlySet("locale")) {
                this.locale(model.getLocale());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            return this;
        }
    }
}

