/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.CreateDatabaseInsightDetails;
import com.oracle.bmc.opsi.model.CredentialDetails;
import com.oracle.bmc.opsi.model.PeComanagedDatabaseConnectionDetails;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entitySource")
@JsonFilter(value="explicitlySetFilter")
public final class CreatePeComanagedDatabaseInsightDetails
extends CreateDatabaseInsightDetails {
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="databaseResourceType")
    private final String databaseResourceType;
    @JsonProperty(value="opsiPrivateEndpointId")
    private final String opsiPrivateEndpointId;
    @JsonProperty(value="dbmPrivateEndpointId")
    private final String dbmPrivateEndpointId;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="credentialDetails")
    private final CredentialDetails credentialDetails;
    @JsonProperty(value="connectionDetails")
    private final PeComanagedDatabaseConnectionDetails connectionDetails;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreatePeComanagedDatabaseInsightDetails(String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String databaseId, String databaseResourceType, String opsiPrivateEndpointId, String dbmPrivateEndpointId, String serviceName, CredentialDetails credentialDetails, PeComanagedDatabaseConnectionDetails connectionDetails, DeploymentType deploymentType, Map<String, Map<String, Object>> systemTags) {
        super(compartmentId, freeformTags, definedTags);
        this.databaseId = databaseId;
        this.databaseResourceType = databaseResourceType;
        this.opsiPrivateEndpointId = opsiPrivateEndpointId;
        this.dbmPrivateEndpointId = dbmPrivateEndpointId;
        this.serviceName = serviceName;
        this.credentialDetails = credentialDetails;
        this.connectionDetails = connectionDetails;
        this.deploymentType = deploymentType;
        this.systemTags = systemTags;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDatabaseResourceType() {
        return this.databaseResourceType;
    }

    public String getOpsiPrivateEndpointId() {
        return this.opsiPrivateEndpointId;
    }

    public String getDbmPrivateEndpointId() {
        return this.dbmPrivateEndpointId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public CredentialDetails getCredentialDetails() {
        return this.credentialDetails;
    }

    public PeComanagedDatabaseConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreatePeComanagedDatabaseInsightDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", databaseResourceType=").append(String.valueOf(this.databaseResourceType));
        sb.append(", opsiPrivateEndpointId=").append(String.valueOf(this.opsiPrivateEndpointId));
        sb.append(", dbmPrivateEndpointId=").append(String.valueOf(this.dbmPrivateEndpointId));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", credentialDetails=").append(String.valueOf((Object)this.credentialDetails));
        sb.append(", connectionDetails=").append(String.valueOf((Object)this.connectionDetails));
        sb.append(", deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePeComanagedDatabaseInsightDetails)) {
            return false;
        }
        CreatePeComanagedDatabaseInsightDetails other = (CreatePeComanagedDatabaseInsightDetails)((Object)o);
        return Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.databaseResourceType, other.databaseResourceType) && Objects.equals(this.opsiPrivateEndpointId, other.opsiPrivateEndpointId) && Objects.equals(this.dbmPrivateEndpointId, other.dbmPrivateEndpointId) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals((Object)this.credentialDetails, (Object)other.credentialDetails) && Objects.equals((Object)this.connectionDetails, (Object)other.connectionDetails) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.databaseResourceType == null ? 43 : this.databaseResourceType.hashCode());
        result = result * 59 + (this.opsiPrivateEndpointId == null ? 43 : this.opsiPrivateEndpointId.hashCode());
        result = result * 59 + (this.dbmPrivateEndpointId == null ? 43 : this.dbmPrivateEndpointId.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.credentialDetails == null ? 43 : this.credentialDetails.hashCode());
        result = result * 59 + (this.connectionDetails == null ? 43 : this.connectionDetails.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        return result;
    }

    public static enum DeploymentType implements BmcEnum
    {
        VirtualMachine("VIRTUAL_MACHINE"),
        BareMetal("BARE_METAL"),
        Exacs("EXACS");

        private final String value;
        private static Map<String, DeploymentType> map;

        private DeploymentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DeploymentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DeploymentType: " + key);
        }

        static {
            map = new HashMap<String, DeploymentType>();
            for (DeploymentType v : DeploymentType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="databaseResourceType")
        private String databaseResourceType;
        @JsonProperty(value="opsiPrivateEndpointId")
        private String opsiPrivateEndpointId;
        @JsonProperty(value="dbmPrivateEndpointId")
        private String dbmPrivateEndpointId;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="credentialDetails")
        private CredentialDetails credentialDetails;
        @JsonProperty(value="connectionDetails")
        private PeComanagedDatabaseConnectionDetails connectionDetails;
        @JsonProperty(value="deploymentType")
        private DeploymentType deploymentType;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder databaseResourceType(String databaseResourceType) {
            this.databaseResourceType = databaseResourceType;
            this.__explicitlySet__.add("databaseResourceType");
            return this;
        }

        public Builder opsiPrivateEndpointId(String opsiPrivateEndpointId) {
            this.opsiPrivateEndpointId = opsiPrivateEndpointId;
            this.__explicitlySet__.add("opsiPrivateEndpointId");
            return this;
        }

        public Builder dbmPrivateEndpointId(String dbmPrivateEndpointId) {
            this.dbmPrivateEndpointId = dbmPrivateEndpointId;
            this.__explicitlySet__.add("dbmPrivateEndpointId");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder credentialDetails(CredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            this.__explicitlySet__.add("credentialDetails");
            return this;
        }

        public Builder connectionDetails(PeComanagedDatabaseConnectionDetails connectionDetails) {
            this.connectionDetails = connectionDetails;
            this.__explicitlySet__.add("connectionDetails");
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public CreatePeComanagedDatabaseInsightDetails build() {
            CreatePeComanagedDatabaseInsightDetails model = new CreatePeComanagedDatabaseInsightDetails(this.compartmentId, this.freeformTags, this.definedTags, this.databaseId, this.databaseResourceType, this.opsiPrivateEndpointId, this.dbmPrivateEndpointId, this.serviceName, this.credentialDetails, this.connectionDetails, this.deploymentType, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreatePeComanagedDatabaseInsightDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("databaseResourceType")) {
                this.databaseResourceType(model.getDatabaseResourceType());
            }
            if (model.wasPropertyExplicitlySet("opsiPrivateEndpointId")) {
                this.opsiPrivateEndpointId(model.getOpsiPrivateEndpointId());
            }
            if (model.wasPropertyExplicitlySet("dbmPrivateEndpointId")) {
                this.dbmPrivateEndpointId(model.getDbmPrivateEndpointId());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("credentialDetails")) {
                this.credentialDetails(model.getCredentialDetails());
            }
            if (model.wasPropertyExplicitlySet("connectionDetails")) {
                this.connectionDetails(model.getConnectionDetails());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

