/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DatabaseConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class DBParameters
extends DatabaseConfigurationMetricGroup {
    @JsonProperty(value="instanceNumber")
    private final Integer instanceNumber;
    @JsonProperty(value="parameterName")
    private final String parameterName;
    @JsonProperty(value="parameterValue")
    private final String parameterValue;
    @JsonProperty(value="snapshotId")
    private final Integer snapshotId;
    @JsonProperty(value="isChanged")
    private final String isChanged;
    @JsonProperty(value="isDefault")
    private final String isDefault;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DBParameters(Date timeCollected, Integer instanceNumber, String parameterName, String parameterValue, Integer snapshotId, String isChanged, String isDefault) {
        super(timeCollected);
        this.instanceNumber = instanceNumber;
        this.parameterName = parameterName;
        this.parameterValue = parameterValue;
        this.snapshotId = snapshotId;
        this.isChanged = isChanged;
        this.isDefault = isDefault;
    }

    public Integer getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public Integer getSnapshotId() {
        return this.snapshotId;
    }

    public String getIsChanged() {
        return this.isChanged;
    }

    public String getIsDefault() {
        return this.isDefault;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DBParameters(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", instanceNumber=").append(String.valueOf(this.instanceNumber));
        sb.append(", parameterName=").append(String.valueOf(this.parameterName));
        sb.append(", parameterValue=").append(String.valueOf(this.parameterValue));
        sb.append(", snapshotId=").append(String.valueOf(this.snapshotId));
        sb.append(", isChanged=").append(String.valueOf(this.isChanged));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DBParameters)) {
            return false;
        }
        DBParameters other = (DBParameters)((Object)o);
        return Objects.equals(this.instanceNumber, other.instanceNumber) && Objects.equals(this.parameterName, other.parameterName) && Objects.equals(this.parameterValue, other.parameterValue) && Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals(this.isChanged, other.isChanged) && Objects.equals(this.isDefault, other.isDefault) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceNumber == null ? 43 : this.instanceNumber.hashCode());
        result = result * 59 + (this.parameterName == null ? 43 : this.parameterName.hashCode());
        result = result * 59 + (this.parameterValue == null ? 43 : this.parameterValue.hashCode());
        result = result * 59 + (this.snapshotId == null ? 43 : this.snapshotId.hashCode());
        result = result * 59 + (this.isChanged == null ? 43 : this.isChanged.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="instanceNumber")
        private Integer instanceNumber;
        @JsonProperty(value="parameterName")
        private String parameterName;
        @JsonProperty(value="parameterValue")
        private String parameterValue;
        @JsonProperty(value="snapshotId")
        private Integer snapshotId;
        @JsonProperty(value="isChanged")
        private String isChanged;
        @JsonProperty(value="isDefault")
        private String isDefault;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder instanceNumber(Integer instanceNumber) {
            this.instanceNumber = instanceNumber;
            this.__explicitlySet__.add("instanceNumber");
            return this;
        }

        public Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            this.__explicitlySet__.add("parameterName");
            return this;
        }

        public Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            this.__explicitlySet__.add("parameterValue");
            return this;
        }

        public Builder snapshotId(Integer snapshotId) {
            this.snapshotId = snapshotId;
            this.__explicitlySet__.add("snapshotId");
            return this;
        }

        public Builder isChanged(String isChanged) {
            this.isChanged = isChanged;
            this.__explicitlySet__.add("isChanged");
            return this;
        }

        public Builder isDefault(String isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public DBParameters build() {
            DBParameters model = new DBParameters(this.timeCollected, this.instanceNumber, this.parameterName, this.parameterValue, this.snapshotId, this.isChanged, this.isDefault);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DBParameters model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("instanceNumber")) {
                this.instanceNumber(model.getInstanceNumber());
            }
            if (model.wasPropertyExplicitlySet("parameterName")) {
                this.parameterName(model.getParameterName());
            }
            if (model.wasPropertyExplicitlySet("parameterValue")) {
                this.parameterValue(model.getParameterValue());
            }
            if (model.wasPropertyExplicitlySet("snapshotId")) {
                this.snapshotId(model.getSnapshotId());
            }
            if (model.wasPropertyExplicitlySet("isChanged")) {
                this.isChanged(model.getIsChanged());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            return this;
        }
    }
}

