/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.DataObjectColumnUnit;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataObjectColumnMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="category")
    private final Category category;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="dataTypeName")
    private final DataTypeName dataTypeName;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="groupName")
    private final String groupName;
    @JsonProperty(value="unitDetails")
    private final DataObjectColumnUnit unitDetails;

    @Deprecated
    @ConstructorProperties(value={"name", "category", "dataType", "dataTypeName", "displayName", "description", "groupName", "unitDetails"})
    public DataObjectColumnMetadata(String name, Category category, String dataType, DataTypeName dataTypeName, String displayName, String description, String groupName, DataObjectColumnUnit unitDetails) {
        this.name = name;
        this.category = category;
        this.dataType = dataType;
        this.dataTypeName = dataTypeName;
        this.displayName = displayName;
        this.description = description;
        this.groupName = groupName;
        this.unitDetails = unitDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getDataType() {
        return this.dataType;
    }

    public DataTypeName getDataTypeName() {
        return this.dataTypeName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public DataObjectColumnUnit getUnitDetails() {
        return this.unitDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataObjectColumnMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", category=").append(String.valueOf((Object)this.category));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", dataTypeName=").append(String.valueOf((Object)this.dataTypeName));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", groupName=").append(String.valueOf(this.groupName));
        sb.append(", unitDetails=").append(String.valueOf((Object)this.unitDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataObjectColumnMetadata)) {
            return false;
        }
        DataObjectColumnMetadata other = (DataObjectColumnMetadata)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.category, (Object)other.category) && Objects.equals(this.dataType, other.dataType) && Objects.equals((Object)this.dataTypeName, (Object)other.dataTypeName) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.groupName, other.groupName) && Objects.equals((Object)this.unitDetails, (Object)other.unitDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.category == null ? 43 : this.category.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.dataTypeName == null ? 43 : this.dataTypeName.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.groupName == null ? 43 : this.groupName.hashCode());
        result = result * 59 + (this.unitDetails == null ? 43 : this.unitDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DataTypeName implements BmcEnum
    {
        Number("NUMBER"),
        Timestamp("TIMESTAMP"),
        Varchar2("VARCHAR2"),
        Other("OTHER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DataTypeName> map;

        private DataTypeName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DataTypeName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DataTypeName', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DataTypeName.class);
            map = new HashMap<String, DataTypeName>();
            for (DataTypeName v : DataTypeName.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Category implements BmcEnum
    {
        Dimension("DIMENSION"),
        Metric("METRIC"),
        TimeDimension("TIME_DIMENSION"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Category> map;

        private Category(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Category create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Category', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Category.class);
            map = new HashMap<String, Category>();
            for (Category v : Category.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="category")
        private Category category;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="dataTypeName")
        private DataTypeName dataTypeName;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="groupName")
        private String groupName;
        @JsonProperty(value="unitDetails")
        private DataObjectColumnUnit unitDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder dataTypeName(DataTypeName dataTypeName) {
            this.dataTypeName = dataTypeName;
            this.__explicitlySet__.add("dataTypeName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            this.__explicitlySet__.add("groupName");
            return this;
        }

        public Builder unitDetails(DataObjectColumnUnit unitDetails) {
            this.unitDetails = unitDetails;
            this.__explicitlySet__.add("unitDetails");
            return this;
        }

        public DataObjectColumnMetadata build() {
            DataObjectColumnMetadata model = new DataObjectColumnMetadata(this.name, this.category, this.dataType, this.dataTypeName, this.displayName, this.description, this.groupName, this.unitDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataObjectColumnMetadata model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("dataTypeName")) {
                this.dataTypeName(model.getDataTypeName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("groupName")) {
                this.groupName(model.getGroupName());
            }
            if (model.wasPropertyExplicitlySet("unitDetails")) {
                this.unitDetails(model.getUnitDetails());
            }
            return this;
        }
    }
}

