/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DataObjectBindParameter;
import com.oracle.bmc.opsi.model.DataObjectQuery;
import com.oracle.bmc.opsi.model.DataObjectQueryTimeFilters;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="queryType")
@JsonFilter(value="explicitlySetFilter")
public final class DataObjectStandardQuery
extends DataObjectQuery {
    @JsonProperty(value="statement")
    private final String statement;
    @JsonProperty(value="timeFilters")
    private final DataObjectQueryTimeFilters timeFilters;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DataObjectStandardQuery(List<DataObjectBindParameter> bindParams, Double queryExecutionTimeoutInSeconds, String statement, DataObjectQueryTimeFilters timeFilters) {
        super(bindParams, queryExecutionTimeoutInSeconds);
        this.statement = statement;
        this.timeFilters = timeFilters;
    }

    public String getStatement() {
        return this.statement;
    }

    public DataObjectQueryTimeFilters getTimeFilters() {
        return this.timeFilters;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataObjectStandardQuery(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", statement=").append(String.valueOf(this.statement));
        sb.append(", timeFilters=").append(String.valueOf((Object)this.timeFilters));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataObjectStandardQuery)) {
            return false;
        }
        DataObjectStandardQuery other = (DataObjectStandardQuery)((Object)o);
        return Objects.equals(this.statement, other.statement) && Objects.equals((Object)this.timeFilters, (Object)other.timeFilters) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.statement == null ? 43 : this.statement.hashCode());
        result = result * 59 + (this.timeFilters == null ? 43 : this.timeFilters.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bindParams")
        private List<DataObjectBindParameter> bindParams;
        @JsonProperty(value="queryExecutionTimeoutInSeconds")
        private Double queryExecutionTimeoutInSeconds;
        @JsonProperty(value="statement")
        private String statement;
        @JsonProperty(value="timeFilters")
        private DataObjectQueryTimeFilters timeFilters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bindParams(List<DataObjectBindParameter> bindParams) {
            this.bindParams = bindParams;
            this.__explicitlySet__.add("bindParams");
            return this;
        }

        public Builder queryExecutionTimeoutInSeconds(Double queryExecutionTimeoutInSeconds) {
            this.queryExecutionTimeoutInSeconds = queryExecutionTimeoutInSeconds;
            this.__explicitlySet__.add("queryExecutionTimeoutInSeconds");
            return this;
        }

        public Builder statement(String statement) {
            this.statement = statement;
            this.__explicitlySet__.add("statement");
            return this;
        }

        public Builder timeFilters(DataObjectQueryTimeFilters timeFilters) {
            this.timeFilters = timeFilters;
            this.__explicitlySet__.add("timeFilters");
            return this;
        }

        public DataObjectStandardQuery build() {
            DataObjectStandardQuery model = new DataObjectStandardQuery(this.bindParams, this.queryExecutionTimeoutInSeconds, this.statement, this.timeFilters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataObjectStandardQuery model) {
            if (model.wasPropertyExplicitlySet("bindParams")) {
                this.bindParams(model.getBindParams());
            }
            if (model.wasPropertyExplicitlySet("queryExecutionTimeoutInSeconds")) {
                this.queryExecutionTimeoutInSeconds(model.getQueryExecutionTimeoutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("statement")) {
                this.statement(model.getStatement());
            }
            if (model.wasPropertyExplicitlySet("timeFilters")) {
                this.timeFilters(model.getTimeFilters());
            }
            return this;
        }
    }
}

